% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_successors.R
\name{get_successors}
\alias{get_successors}
\title{Get node IDs for successor nodes to the specified node}
\usage{
get_successors(graph, node)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph}.}

\item{node}{a node ID for the selected node.}
}
\value{
a vector of node ID values.
}
\description{
Provides a vector of node IDs for all nodes that have a
connection from the given node.
}
\examples{
\dontrun{
# Before getting node ID values for successors of
# a specified node, create a simple graph
nodes <-
  create_nodes(nodes = LETTERS,
               label = TRUE,
               type = c(rep("a_to_g", 7),
                        rep("h_to_p", 9),
                        rep("q_to_x", 8),
                        rep("y_and_z",2)))

edges <-
  create_edges(from = sample(LETTERS, replace = TRUE),
               to = sample(LETTERS, replace = TRUE),
               label = "edge",
               rel = "letter_to_letter")

graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges,
               graph_attrs = "layout = neato",
               node_attrs = c("fontname = Helvetica",
                              "shape = circle"))

# Get sucessors for node "A" in the graph
get_successors(graph, node = "A")
#> [1] "Z" "Y"

# If there are no successors, NA is returned
get_successors(graph, node = "Z")
#> [1] NA
}
}

