% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_global_graph_attrs.R
\name{get_global_graph_attrs}
\alias{get_global_graph_attrs}
\title{Get global graph attributes}
\usage{
get_global_graph_attrs(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}
}
\value{
a list object containing global attributes
for a graph.
}
\description{
Get the presently set global attributes
for a graph object of class \code{dgr_graph}.
}
\examples{
library(magrittr)

# Create a new graph and set some global attributes
graph <-
  create_graph() \%>\%
  set_global_graph_attrs(
    "graph", "overlap", "true") \%>\%
  set_global_graph_attrs(
    "node", "fontname", "Helvetica") \%>\%
  set_global_graph_attrs(
    "edge", "color", "gray")

# Verify that the global attributes have been set
get_global_graph_attrs(graph)
#> $graph_attrs
#> [1] "overlap = true"
#>
#> $node_attrs
#> [1] "fontname = Helvetica"
#>
#> $edge_attrs
#> [1] "color = gray"
}

