% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_graph.R
\name{import_graph}
\alias{import_graph}
\title{Import a graph from various graph formats}
\usage{
import_graph(graph_file, file_type = NULL, graph_name = NULL,
  graph_time = NULL, graph_tz = NULL)
}
\arguments{
\item{graph_file}{a connection to a graph file.}

\item{file_type}{the type of file to be imported. Options are:
\code{graphml} (GraphML), \code{gml} (GML), and \code{sif} (SIF). If not
supplied, the function will infer the type by its file extension.}

\item{graph_name}{an optional string for labeling the graph object.}

\item{graph_time}{a date or date-time string (required for insertion of
graph into a graph series of the type \code{temporal}).}

\item{graph_tz}{an optional value for the time zone (\code{tz})
corresponding to the date or date-time string supplied as a value to
\code{graph_time}. If no time zone is provided then it will be set to
\code{GMT}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Import a variety of graphs from different graph formats and
create a graph object.
}

