% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_nodes.R
\name{create_nodes}
\alias{create_nodes}
\title{Create a data frame with nodes and their attributes}
\usage{
create_nodes(nodes, type = NULL, label = nodes, ...)
}
\arguments{
\item{nodes}{the node ID value(s) for the node(s) to be created.}

\item{type}{an optional 'type' description for each node.}

\item{label}{an optional label for each node.}

\item{...}{one or more named vectors for associated attributes.}
}
\value{
a data frame.
}
\description{
Combine several named vectors for nodes and their attributes
into a data frame, which can be combined with other similarly-generated data
frame, or, added to a graph object.
}
\examples{
\dontrun{
# Create a node data frame
nodes <-
  create_nodes(nodes = c("a", "b", "c", "d"),
               type = "letter",
               label = TRUE,
               style = "filled",
               color = "aqua",
               shape = c("circle", "circle",
                         "rectangle", "rectangle"),
               value = c(3.5, 2.6, 9.4, 2.7))
}
}

