% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{plotBlocks}
\alias{plotBlocks}
\title{Plots blocks of data}
\usage{
plotBlocks(data, show.number = TRUE, block.fun = deprects,
  ic.scale = TRUE, add = FALSE, ...)
}
\arguments{
\item{data}{the data, a single \link{DLData} object or a list of \code{DLData} objects}

\item{show.number}{if \code{true}, the number of sequences (in total) in data is displayed on the left side of the plot}

\item{block.fun}{the function called for each of the blocks}

\item{ic.scale}{if \code{TRUE}, output of \code{block.fun} may be scaled by "information content"}

\item{add}{if \code{TRUE}, the plot is added to an existing plot}

\item{...}{if \code{add=FALSE} forwarded to the internal call to \link[graphics]{plot}}
}
\description{
Plots the blocks of data in \code{data} by successive, vertically arranged sub-plots of the function provided as \code{block.fun}.
If \code{data} is a single \link{DLData} object, one block is plotted. Further arguments are provided to \code{block.fun}
}
\examples{
# read data and create DLData object
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1], weights = log1p(seqs[, 2]) )

# plot all data
plotBlocks(data)

# partition data
partitions <- partition(data, threshold = 0.3)
# and plot partitions
plotBlocks(partitions)

# or plot partitions as sequence logos
plotBlocks(partitions, block.fun = logo)
}
\seealso{
\link{deprects}

\link{logo}

\link{colorchart}
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
