% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_ensemble.R
\name{response_model}
\alias{response_model}
\title{Response model from experimental data using SL ensemble}
\usage{
response_model(
  response.formula,
  exp.data,
  compl.var,
  exp.compliers,
  family = "binomial",
  ID = NULL,
  SL.library = c("SL.glmnet", "SL.xgboost", "SL.ranger", "SL.nnet", "SL.glm")
)
}
\arguments{
\item{response.formula}{formula to fit the response model (y ~ x) using
binary outcome variable and covariates}

\item{exp.data}{experimental dataset.}

\item{compl.var}{string specifying binary complier variable}

\item{exp.compliers}{\code{data.frame} object of compliers from
\code{complier_predict}.}

\item{family}{string for \code{"gaussian"} or \code{"binomial"}.}

\item{ID}{string for identifier variable.}

\item{SL.library}{vector of names of ML algorithms used for ensemble model.}
}
\value{
trained response model.
}
\description{
Train response model (response variable as outcome and covariates) from all
compliers (actual + predicted) in experimental data using SL ensemble.
}
