/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmFileCacheTileLoader
extends OsmTileLoader {
    private static final Logger log = Logger.getLogger(OsmFileCacheTileLoader.class.getName());
    private static final String ETAG_FILE_EXT = ".etag";
    private static final String TAGS_FILE_EXT = ".tags";
    private static final Charset TAGS_CHARSET = Charset.forName("UTF-8");
    public static final long FILE_AGE_ONE_DAY = 86400000L;
    public static final long FILE_AGE_ONE_WEEK = 604800000L;
    protected String cacheDirBase;
    protected long maxCacheFileAge = 604800000L;
    protected long recheckAfter = 86400000L;

    public static File getDefaultCacheDir() throws SecurityException {
        String tempDir = null;
        String userName = System.getProperty("user.name");
        try {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        catch (SecurityException e) {
            log.log(Level.WARNING, "Failed to access system property ''java.io.tmpdir'' for security reasons. Exception was: " + e.toString());
            throw e;
        }
        try {
            if (tempDir == null) {
                throw new IOException("No temp directory set");
            }
            String subDirName = "JMapViewerTiles";
            if (userName != null && userName.length() > 0) {
                subDirName = subDirName + "_" + userName;
            }
            File cacheDir = new File(tempDir, subDirName);
            return cacheDir;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OsmFileCacheTileLoader(TileLoaderListener map, File cacheDir) throws IOException {
        super(map);
        if (cacheDir == null || !cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new IOException("Cannot access cache directory");
        }
        log.finest("Tile cache directory: " + cacheDir);
        this.cacheDirBase = cacheDir.getAbsolutePath();
    }

    public OsmFileCacheTileLoader(TileLoaderListener map) throws SecurityException, IOException {
        this(map, OsmFileCacheTileLoader.getDefaultCacheDir());
    }

    public Runnable createTileLoaderJob(TileSource source, int tilex, int tiley, int zoom) {
        return new FileLoadJob(source, tilex, tiley, zoom);
    }

    public long getMaxFileAge() {
        return this.maxCacheFileAge;
    }

    public void setCacheMaxFileAge(long maxFileAge) {
        this.maxCacheFileAge = maxFileAge;
    }

    public String getCacheDirBase() {
        return this.cacheDirBase;
    }

    public void setTileCacheDir(String tileCacheDir) {
        File dir = new File(tileCacheDir);
        dir.mkdirs();
        this.cacheDirBase = dir.getAbsolutePath();
    }

    protected class FileLoadJob
    implements Runnable {
        InputStream input = null;
        int tilex;
        int tiley;
        int zoom;
        Tile tile;
        TileSource source;
        File tileCacheDir;
        File tileFile = null;
        long fileAge = 0L;
        boolean fileTilePainted = false;

        public FileLoadJob(TileSource source, int tilex, int tiley, int zoom) {
            this.source = source;
            this.tilex = tilex;
            this.tiley = tiley;
            this.zoom = zoom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TileCache cache;
            TileCache tileCache = cache = OsmFileCacheTileLoader.this.listener.getTileCache();
            synchronized (tileCache) {
                this.tile = cache.getTile(this.source, this.tilex, this.tiley, this.zoom);
                if (this.tile == null || this.tile.isLoaded() || this.tile.loading) {
                    return;
                }
                this.tile.loading = true;
            }
            this.tileCacheDir = new File(OsmFileCacheTileLoader.this.cacheDirBase, this.source.getName().replaceAll("[\\\\/:*?\"<>|]", "_"));
            if (!this.tileCacheDir.exists()) {
                this.tileCacheDir.mkdirs();
            }
            if (this.loadTileFromFile()) {
                return;
            }
            if (this.fileTilePainted) {
                Runnable job = new Runnable(){

                    public void run() {
                        FileLoadJob.this.loadOrUpdateTile();
                    }
                };
                JobDispatcher.getInstance().addJob(job);
            } else {
                this.loadOrUpdateTile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadOrUpdateTile() {
            try {
                URLConnection urlConn = OsmFileCacheTileLoader.this.loadTileFromOsm(this.tile);
                if (this.tileFile != null) {
                    switch (this.source.getTileUpdate()) {
                        case IfModifiedSince: {
                            urlConn.setIfModifiedSince(this.fileAge);
                            break;
                        }
                        case LastModified: {
                            if (this.isOsmTileNewer(this.fileAge)) break;
                            log.finest("LastModified test: local version is up to date: " + this.tile);
                            this.tile.setLoaded(true);
                            this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                            return;
                        }
                    }
                }
                if (this.source.getTileUpdate() == TileSource.TileUpdate.ETag || this.source.getTileUpdate() == TileSource.TileUpdate.IfNoneMatch) {
                    String fileETag = this.tile.getValue("etag");
                    if (fileETag != null) {
                        switch (this.source.getTileUpdate()) {
                            case IfNoneMatch: {
                                urlConn.addRequestProperty("If-None-Match", fileETag);
                                break;
                            }
                            case ETag: {
                                if (!this.hasOsmTileETag(fileETag)) break;
                                this.tile.setLoaded(true);
                                this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                                return;
                            }
                        }
                    }
                    this.tile.putValue("etag", urlConn.getHeaderField("ETag"));
                }
                if (urlConn instanceof HttpURLConnection && ((HttpURLConnection)urlConn).getResponseCode() == 304) {
                    log.finest("ETag test: local version is up to date: " + this.tile);
                    this.tile.setLoaded(true);
                    this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                    return;
                }
                OsmFileCacheTileLoader.this.loadTileMetadata(this.tile, urlConn);
                this.saveTagsToFile();
                if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                    this.tile.setError("No tile at this zoom level");
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                } else {
                    byte[] buffer = this.loadTileInBuffer(urlConn);
                    if (buffer != null) {
                        this.tile.loadImage(new ByteArrayInputStream(buffer));
                        this.tile.setLoaded(true);
                        OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                        this.saveTileToFile(buffer);
                    }
                }
            }
            catch (Exception e) {
                this.tile.setError(e.getMessage());
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, false);
                if (this.input == null) {
                    System.err.println("failed loading " + this.zoom + "/" + this.tilex + "/" + this.tiley + " " + e.getMessage());
                }
            }
            finally {
                this.tile.loading = false;
                this.tile.setLoaded(true);
            }
        }

        protected boolean loadTileFromFile() {
            FileInputStream fin = null;
            try {
                boolean oldTile;
                this.tileFile = this.getTileFile();
                this.loadTagsFromFile();
                if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                    this.tile.setError("No tile at this zoom level");
                    if (this.tileFile.exists()) {
                        this.tileFile.delete();
                    }
                    this.tileFile = this.getTagsFile();
                } else {
                    fin = new FileInputStream(this.tileFile);
                    if (fin.available() == 0) {
                        throw new IOException("File empty");
                    }
                    this.tile.loadImage(fin);
                    fin.close();
                }
                this.fileAge = this.tileFile.lastModified();
                boolean bl = oldTile = System.currentTimeMillis() - this.fileAge > OsmFileCacheTileLoader.this.maxCacheFileAge;
                if (!oldTile) {
                    this.tile.setLoaded(true);
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                    this.fileTilePainted = true;
                    return true;
                }
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                this.fileTilePainted = true;
            }
            catch (Exception e) {
                try {
                    if (fin != null) {
                        fin.close();
                        this.tileFile.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.tileFile = null;
                this.fileAge = 0L;
            }
            return false;
        }

        protected byte[] loadTileInBuffer(URLConnection urlConn) throws IOException {
            this.input = urlConn.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.input.available());
            byte[] buffer = new byte[2048];
            boolean finished = false;
            do {
                int read;
                if ((read = this.input.read(buffer)) >= 0) {
                    bout.write(buffer, 0, read);
                    continue;
                }
                finished = true;
            } while (!finished);
            if (bout.size() == 0) {
                return null;
            }
            return bout.toByteArray();
        }

        protected boolean isOsmTileNewer(long fileAge) throws IOException {
            URL url = new URL(this.tile.getUrl());
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            OsmFileCacheTileLoader.this.prepareHttpUrlConnection(urlConn);
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            long lastModified = urlConn.getLastModified();
            if (lastModified == 0L) {
                return true;
            }
            return lastModified > fileAge;
        }

        protected boolean hasOsmTileETag(String eTag) throws IOException {
            URL url = new URL(this.tile.getUrl());
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            OsmFileCacheTileLoader.this.prepareHttpUrlConnection(urlConn);
            urlConn.setRequestMethod("HEAD");
            urlConn.setReadTimeout(30000);
            String osmETag = urlConn.getHeaderField("ETag");
            if (osmETag == null) {
                return true;
            }
            return osmETag.equals(eTag);
        }

        protected File getTileFile() {
            return new File(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.source.getTileType());
        }

        protected File getTagsFile() {
            return new File(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + OsmFileCacheTileLoader.TAGS_FILE_EXT);
        }

        protected void saveTileToFile(byte[] rawData) {
            try {
                FileOutputStream f = new FileOutputStream(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.source.getTileType());
                f.write(rawData);
                f.close();
            }
            catch (Exception e) {
                System.err.println("Failed to save tile content: " + e.getLocalizedMessage());
            }
        }

        protected void saveTagsToFile() {
            File tagsFile = this.getTagsFile();
            if (this.tile.getMetadata() == null) {
                tagsFile.delete();
                return;
            }
            try {
                PrintWriter f = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tagsFile), TAGS_CHARSET));
                for (Map.Entry<String, String> entry : this.tile.getMetadata().entrySet()) {
                    f.println(entry.getKey() + "=" + entry.getValue());
                }
                f.close();
            }
            catch (Exception e) {
                System.err.println("Failed to save tile tags: " + e.getLocalizedMessage());
            }
        }

        private void loadOldETagfromFile() {
            File etagFile = new File(this.tileCacheDir, this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + OsmFileCacheTileLoader.ETAG_FILE_EXT);
            if (!etagFile.exists()) {
                return;
            }
            try {
                FileInputStream f = new FileInputStream(etagFile);
                byte[] buf = new byte[f.available()];
                f.read(buf);
                f.close();
                String etag = new String(buf, TAGS_CHARSET.name());
                this.tile.putValue("etag", etag);
                if (etagFile.delete()) {
                    this.saveTagsToFile();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load compatiblity etag: " + e.getLocalizedMessage());
            }
        }

        protected void loadTagsFromFile() {
            this.loadOldETagfromFile();
            File tagsFile = this.getTagsFile();
            try {
                BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tagsFile), TAGS_CHARSET));
                String line = f.readLine();
                while (line != null) {
                    int i = line.indexOf(61);
                    if (i == -1 || i == 0) {
                        System.err.println("Malformed tile tag in file '" + tagsFile.getName() + "':" + line);
                    } else {
                        this.tile.putValue(line.substring(0, i), line.substring(i + 1));
                    }
                    line = f.readLine();
                }
                f.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                System.err.println("Failed to load tile tags: " + e.getLocalizedMessage());
            }
        }
    }
}

