/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.RDialog;
import org.rosuda.deducer.widgets.SingleVariableWidget;
import org.rosuda.deducer.widgets.SliderWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;

public class PlotRDialog
extends RDialog
implements ActionListener {
    private VariableSelectorWidget variableSelector;
    private SingleVariableWidget yaxis;
    private SingleVariableWidget xaxis;
    private SliderWidget slider;

    public void initGUI() {
        super.initGUI();
        this.variableSelector = new VariableSelectorWidget();
        this.add((Component)this.variableSelector, new AnchorConstraint(12, 428, 900, 12, 2, 1, 1, 2));
        this.variableSelector.setPreferredSize(new Dimension(216, 379));
        this.variableSelector.setTitle("Data");
        this.yaxis = new SingleVariableWidget("y axis", this.variableSelector);
        this.add((Component)this.yaxis, new AnchorConstraint(121, 978, 327, 460, 1, 1, 1, 1));
        this.yaxis.setPreferredSize(new Dimension(276, 63));
        this.xaxis = new SingleVariableWidget("x axis", this.variableSelector);
        this.add((Component)this.xaxis, new AnchorConstraint(337, 978, 540, 460, 1, 1, 1, 1));
        this.xaxis.setPreferredSize(new Dimension(276, 63));
        this.slider = new SliderWidget("Alpha level", new String[]{"Transparent", "Opaque"});
        this.add((Component)this.slider, new AnchorConstraint(610, 978, 840, 460, 1, 1, 1, 1));
        this.slider.setPreferredSize(new Dimension(187, 44));
        this.slider.setDefaultModel(new Integer(100));
        this.setTitle("Scatter Plot");
        this.setOkayCancel(true, true, this);
        this.addHelpButton("pmwiki.php");
        this.setSize(555, 445);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Run") {
            String string2 = this.xaxis.getSelectedVariable();
            String string3 = this.yaxis.getSelectedVariable();
            String string4 = this.variableSelector.getSelectedData();
            String string5 = new Double((double)this.slider.getValue() / 100.0).toString();
            if (string3 == null || string2 == null || string4 == null) {
                JOptionPane.showMessageDialog(this, "You must specify both an x and y variable");
                return;
            }
            String string6 = "qplot(" + string2 + ", " + string3 + ", data=" + string4 + ",alpha=I(" + string5 + "))";
            Deducer.execute(string6);
            this.completed();
            this.setVisible(false);
        } else if (string == "Cancel") {
            this.setVisible(false);
        } else if (string == "Reset") {
            this.reset();
        }
    }
}

