/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.widgets.ButtonGroupWidget;
import org.rosuda.deducer.widgets.CheckBoxesWidget;
import org.rosuda.deducer.widgets.ComboBoxWidget;
import org.rosuda.deducer.widgets.DeducerWidget;
import org.rosuda.deducer.widgets.SingleVariableWidget;
import org.rosuda.deducer.widgets.SliderWidget;
import org.rosuda.deducer.widgets.TextAreaWidget;
import org.rosuda.deducer.widgets.VariableListWidget;
import org.rosuda.deducer.widgets.VariableSelectorWidget;

public class ExampleDialog
extends JDialog
implements ActionListener {
    private VariableSelectorWidget variableSelector;
    private OkayCancelPanel okayCancelPanel;
    private SliderWidget slider;
    private ComboBoxWidget comboBox;
    private TextAreaWidget textArea;
    private ButtonGroupWidget radioButtons;
    private CheckBoxesWidget checkBoxes;
    private SingleVariableWidget singleVariableSelector;
    private HelpButton helpButton;
    private VariableListWidget variableList;
    private Vector widgets = new Vector();
    private static ExampleDialog theDialog;

    public static void run() {
        if (theDialog == null) {
            theDialog = new ExampleDialog(null);
        }
        theDialog.setToLast();
        theDialog.setVisible(true);
    }

    public ExampleDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.slider = new SliderWidget("SliderWidget.java", new String[]{"begin lab", "end lab"});
            this.getContentPane().add((Component)this.slider, new AnchorConstraint(810, 931, 920, 580, 1, 1, 1, 1));
            this.slider.setPreferredSize(new Dimension(187, 44));
            this.comboBox = new ComboBoxWidget("ComboBoxWidget.java", new String[]{"Default Option", "option 1", "option 2"});
            this.getContentPane().add((Component)this.comboBox, new AnchorConstraint(675, 378, 764, 23, 1, 1, 1, 1));
            this.comboBox.setPreferredSize(new Dimension(189, 29));
            this.comboBox.setDefaultModel("Default Option");
            this.textArea = new TextAreaWidget("TextAreaWidget.java");
            this.getContentPane().add((Component)this.textArea, new AnchorConstraint(764, 378, 900, 23, 1, 1, 1, 1));
            this.textArea.setPreferredSize(new Dimension(189, 54));
            this.radioButtons = new ButtonGroupWidget("ButtonGroupWidget.java", new String[]{"option 1", "option 2", "option 3"});
            this.getContentPane().add((Component)this.radioButtons, new AnchorConstraint(651, 931, 805, 580, 1, 1, 0, 1));
            this.radioButtons.setPreferredSize(new Dimension(187, 97));
            this.checkBoxes = new CheckBoxesWidget("CheckBoxesWidget.java", new String[]{"option 1", "option 2", "option 3", "option 4", "option 5", "option 6"}, 2);
            this.getContentPane().add((Component)this.checkBoxes, new AnchorConstraint(437, 931, 631, 580, 1, 1, 1, 1));
            this.checkBoxes.setPreferredSize(new Dimension(187, 115));
            this.checkBoxes.addButton(new JCheckBox("added"));
            this.helpButton = new HelpButton("pmwiki.php?n=Main.ExampleDialog");
            this.getContentPane().add((Component)this.helpButton, new AnchorConstraint(940, 77, 980, 23, 0, 0, 1, 1));
            this.helpButton.setPreferredSize(new Dimension(32, 32));
            this.okayCancelPanel = new OkayCancelPanel(true, true, this);
            this.getContentPane().add((Component)this.okayCancelPanel, new AnchorConstraint(926, 978, 980, 402, 0, 1, 1, 0));
            this.okayCancelPanel.setPreferredSize(new Dimension(307, 32));
            this.variableSelector = new VariableSelectorWidget();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(12, 428, 660, 12, 2, 1, 1, 2));
            this.variableSelector.setPreferredSize(new Dimension(216, 379));
            this.variableSelector.setTitle("VariableSelectorWidget.java");
            this.variableList = new VariableListWidget("VariableListWidget.java", this.variableSelector);
            this.getContentPane().add((Component)this.variableList, new AnchorConstraint(21, 978, 301, 460, 1, 1, 1, 1));
            this.variableList.setPreferredSize(new Dimension(276, 166));
            this.singleVariableSelector = new SingleVariableWidget("SingleVariableWidget.java", this.variableSelector);
            this.getContentPane().add((Component)this.singleVariableSelector, new AnchorConstraint(321, 978, 427, 460, 1, 1, 1, 1));
            this.singleVariableSelector.setPreferredSize(new Dimension(276, 63));
            this.widgets.add(this.variableSelector);
            this.widgets.add(this.variableList);
            this.widgets.add(this.singleVariableSelector);
            this.widgets.add(this.checkBoxes);
            this.widgets.add(this.radioButtons);
            this.widgets.add(this.comboBox);
            this.widgets.add(this.textArea);
            this.widgets.add(this.slider);
            this.reset();
            this.setSize(553, 645);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void reset() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            ((DeducerWidget)this.widgets.get(i)).reset();
        }
    }

    private void setToLast() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            ((DeducerWidget)this.widgets.get(i)).resetToLast();
        }
    }

    private void completed() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            DeducerWidget deducerWidget = (DeducerWidget)this.widgets.get(i);
            deducerWidget.setLastModel(deducerWidget.getModel());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Run") {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.widgets.size(); ++i) {
                DeducerWidget deducerWidget = (DeducerWidget)this.widgets.get(i);
                vector.add("\n'" + deducerWidget.getTitle() + "'=" + deducerWidget.getRModel());
            }
            String string2 = Deducer.makeRCollection(vector, "list", false);
            Deducer.execute(string2);
            this.completed();
            this.setVisible(false);
        } else if (string == "Cancel") {
            this.setVisible(false);
        } else if (string == "Reset") {
            this.reset();
        }
    }
}

