/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import javax.swing.JOptionPane;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.models.GLMBuilder;
import org.rosuda.deducer.models.LinearDialog;
import org.rosuda.deducer.models.LinearExplorer;
import org.rosuda.deducer.models.LinearModel;
import org.rosuda.deducer.models.ModelModel;
import org.rosuda.deducer.toolkit.HelpButton;

public class LinearBuilder
extends GLMBuilder {
    public LinearBuilder(ModelModel modelModel) {
        super(modelModel);
        if (!(modelModel instanceof LinearModel)) {
            JOptionPane.showMessageDialog(this, "Internal Error: Invalid ModelModel");
            modelModel = new LinearModel();
        }
        this.setModel(modelModel);
        this.help.setUrl(HelpButton.baseUrl + "pmwiki.php?n=Main.LinearModel");
        this.setTitle("Linear Regression Model Builder");
    }

    public void specify() {
        if (!(this.model instanceof LinearModel)) {
            JOptionPane.showMessageDialog(this, "Internal Error: Invalid ModelModel");
            this.setModel(new LinearModel());
        }
        LinearDialog linearDialog = new LinearDialog((LinearModel)this.model);
        linearDialog.setLocationRelativeTo(this);
        linearDialog.setVisible(true);
        WindowTracker.addWindow(linearDialog);
        this.dispose();
    }

    public void done() {
        if (!(this.model instanceof LinearModel)) {
            JOptionPane.showMessageDialog(this, "Internal Error: Invalid ModelModel");
            this.setModel(new LinearModel());
            return;
        }
        if (this.modelTerms.getModel().getSize() < 1) {
            JOptionPane.showMessageDialog(this, "Please enter some terms into the model.");
            return;
        }
        this.updateModel();
        LinearExplorer linearExplorer = new LinearExplorer((LinearModel)this.model);
        linearExplorer.setLocationRelativeTo(this);
        linearExplorer.setVisible(true);
        WindowTracker.addWindow(linearExplorer);
        this.dispose();
    }
}

