/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import java.util.Enumeration;
import java.util.Vector;

public class Node {
    protected Vector ch;
    protected Node par;
    protected int level;
    protected int height;

    public Node() {
    }

    public Node(Node node) {
        if (node != null) {
            this.ch = new Vector();
            this.ch.addElement(node);
            node.par = this;
            node.level = this.level + 1;
            node.rebuildLevels();
            this.rebuildHeight();
        }
    }

    public boolean isLeaf() {
        return this.ch == null || this.ch.isEmpty();
    }

    public boolean isRoot() {
        return this.par == null;
    }

    public Node[] getChildren() {
        if (this.ch == null || this.ch.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Node[this.ch.size()];
        this.ch.copyInto(objectArray);
        return objectArray;
    }

    public int count() {
        return this.ch == null ? 0 : this.ch.size();
    }

    public Node at(int n) {
        return this.ch == null || n < 0 || n >= this.ch.size() ? null : (Node)this.ch.elementAt(n);
    }

    public void add(Node node) {
        if (this.ch == null) {
            this.ch = new Vector();
        }
        this.ch.addElement(node);
        node.par = this;
        node.level = this.level + 1;
        node.rebuildLevels();
        if (node.height + 1 > this.height) {
            this.height = node.height + 1;
        }
        if (this.par != null) {
            this.par.rebuildHeight();
        }
    }

    public void prune() {
        if (this.par != null) {
            this.par.remove(this);
            this.par = null;
            this.level = 0;
            this.rebuildLevels();
        }
    }

    public void remove(Node node) {
        if (node == null || node.par != this) {
            return;
        }
        this.ch.removeElement(node);
        node.par = null;
        node.level = 0;
        node.rebuildLevels();
        this.rebuildHeight();
    }

    public Enumeration children() {
        return this.ch == null ? null : this.ch.elements();
    }

    public Node getParent() {
        return this.par;
    }

    public void getNodesAtLevel(int n, Vector vector) {
        if (this.level > n) {
            return;
        }
        if (this.level == n) {
            vector.addElement(this);
            return;
        }
        if (this.ch != null && this.ch.size() > 0) {
            Enumeration enumeration = this.ch.elements();
            while (enumeration.hasMoreElements()) {
                ((Node)enumeration.nextElement()).getNodesAtLevel(n, vector);
            }
        }
    }

    public Node getRoot() {
        return this.par == null ? this : this.par.getRoot();
    }

    public int getLevel() {
        return this.level;
    }

    public int getHeight() {
        return this.height;
    }

    public void getAllNodes(Vector vector) {
        vector.addElement(this);
        if (this.ch != null && this.ch.size() > 0) {
            Enumeration enumeration = this.ch.elements();
            while (enumeration.hasMoreElements()) {
                ((Node)enumeration.nextElement()).getAllNodes(vector);
            }
        }
    }

    public int getNumNodes(boolean bl) {
        int n = 0;
        if (!bl || this.isLeaf()) {
            n = 1;
        }
        if (this.ch != null && this.ch.size() > 0) {
            Enumeration enumeration = this.ch.elements();
            while (enumeration.hasMoreElements()) {
                n += ((Node)enumeration.nextElement()).getNumNodes(bl);
            }
        }
        return n;
    }

    public void rebuildLevels() {
        if (this.ch != null && this.ch.size() > 0) {
            Enumeration enumeration = this.ch.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                node.level = this.level + 1;
                node.rebuildLevels();
            }
        }
    }

    public void rebuildHeight() {
        this.height = 0;
        if (this.ch != null && this.ch.size() > 0) {
            Enumeration enumeration = this.ch.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                if (node.height + 1 <= this.height) continue;
                this.height = node.height + 1;
            }
        }
        if (this.par != null) {
            this.par.rebuildHeight();
        }
    }
}

