/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.toolkit.PPrimRectangle;
import org.rosuda.pograss.PoGraSS;

public class PPrimMosaic
extends PPrimRectangle {
    public Color fillColorEmpty = null;
    public Color borderColorEmpty = Color.RED;
    public Color binbgColor = new Color(Color.lightGray.getRed(), Color.lightGray.getGreen(), Color.lightGray.getBlue(), 76);
    public Color borderColorSelCensored = Color.RED;
    public Color borderColorSelUncensored = this.COL_OUTLINE;
    public Color borderColorCensored = Color.RED;
    public Color fillColorCensored = Color.RED;
    public String info = null;
    private char dir;
    private boolean censored;
    private double obs;
    public static final int TYPE_OBSERVED = 0;
    public static final int TYPE_EXPECTED = 1;
    public static final int TYPE_SAMEBINSIZE = 2;
    public static final int TYPE_MULTIPLEBARCHARTS = 3;
    public static final int TYPE_FLUCTUATION = 4;
    private int type = 0;
    private int origX;
    private int origY;
    private int fullW;
    private int fullH;
    private double p;
    private double exp;
    private double scale;

    public String toString() {
        return this.info;
    }

    public void paint(PoGraSS poGraSS, int n, SMarker sMarker) {
        if (this.r == null) {
            return;
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                Color color;
                Color color2;
                if (this.isEmpty()) {
                    color2 = this.fillColorEmpty;
                    color = this.drawBorder ? this.borderColorEmpty : null;
                } else {
                    color2 = this.fillColor;
                    Color color3 = color = this.drawBorder ? this.borderColor : null;
                }
                if (!this.isBrushed(sMarker) || this.isEmpty() || this.type == 1) {
                    this.drawRect(poGraSS, this.r, color2, color);
                    break;
                }
                this.brushRect(poGraSS, sMarker, n, this.r, color);
                break;
            }
            case 3: 
            case 4: {
                this.drawRect(poGraSS, this.origX, this.origY, this.fullW, this.fullH, this.binbgColor, this.binbgColor);
                if (this.isEmpty()) break;
                if (this.isBrushed(sMarker)) {
                    this.brushRect(poGraSS, sMarker, n, this.r, this.censored ? this.borderColorCensored : this.borderColor);
                    break;
                }
                this.drawRect(poGraSS, this.r, this.fillColor, this.censored ? this.borderColorCensored : this.borderColor);
            }
        }
    }

    private double pnorm(double d) {
        double d2 = 0.9999999;
        double d3 = 1.0E-7;
        while (Math.abs(d2 - d3) > 1.0E-4) {
            if (this.qnorm((d2 + d3) / 2.0) <= d) {
                d3 = (d2 + d3) / 2.0;
                continue;
            }
            d2 = (d2 + d3) / 2.0;
        }
        return d2;
    }

    private double qnorm(double d) {
        double d2 = Math.pow(-2.0 * Math.log(1.0 - d), 0.5);
        return d2 - (2.515517 + 0.802853 * d2 + 0.010328 * d2 * d2) / (1.0 + 1.432788 * d2 + 0.189269 * d2 * d2 + 0.001308 * d2 * d2 * d2);
    }

    public void setObs(double d) {
        this.obs = d;
    }

    public double getObs() {
        return this.obs;
    }

    public char getDir() {
        return this.dir;
    }

    public void setDir(char c) {
        this.dir = c;
    }

    public boolean isCensored() {
        return this.censored;
    }

    public void setCensored(boolean bl) {
        this.censored = bl;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isEmpty() {
        return this.ref.length == 0;
    }

    public void changeDimension(int n, int n2) {
        this.fullW = this.r.width;
        this.fullH = this.r.height;
        this.origX = this.r.x;
        this.origY = this.r.y;
        this.r.y += this.fullH - n2;
        this.r.width = n;
        this.r.height = n2;
    }

    public void setP(double d) {
        this.p = d;
    }

    public void setExp(double d) {
        this.exp = d;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public boolean contains(int n, int n2) {
        if (this.type == 3 || this.type == 4) {
            return n >= this.origX && n <= this.origX + this.fullW && n2 >= this.origY && n2 <= this.origY + this.fullH;
        }
        if (this.type == 2) {
            return n >= this.r.x && n <= this.r.x + this.r.width && n2 >= this.r.y && n2 <= this.r.y + this.r.height;
        }
        return super.contains(n, n2);
    }

    public void paintSelected(PoGraSS poGraSS, int n, SMarker sMarker) {
        this.borderColorSel = this.censored ? this.borderColorSelCensored : this.borderColorSelUncensored;
        super.paintSelected(poGraSS, n, sMarker);
    }
}

