/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.BQSQLFeatureNotSupportedException;
import net.starschema.clouddb.jdbc.BQSQLXML;
import net.starschema.clouddb.jdbc.Logger;

abstract class ScrollableResultset<T>
implements ResultSet {
    Logger logger = Logger.getLogger(ScrollableResultset.class.getName());
    protected InputStream Strm = null;
    protected boolean wasnull = false;
    protected T[] RowsofResult;
    protected int Cursor = -1;
    protected Boolean Closed = false;

    ScrollableResultset() {
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null) {
            return false;
        }
        if (row > 0) {
            if (row <= this.RowsofResult.length) {
                this.Cursor = row - 1;
                return true;
            }
            this.Cursor = this.RowsofResult.length;
            return false;
        }
        if (row < 0) {
            if (Math.abs(row) <= this.RowsofResult.length) {
                this.Cursor = this.RowsofResult.length + row;
                return true;
            }
            this.Cursor = -1;
            return false;
        }
        if (this.Cursor == this.RowsofResult.length || this.Cursor == -1) {
            return false;
        }
        this.Cursor = -1;
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null) {
            return;
        }
        if (this.RowsofResult.length > 0) {
            this.Cursor = this.RowsofResult.length;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.RowsofResult == null) {
            return;
        }
        if (this.RowsofResult.length > 0) {
            this.Cursor = -1;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("cancelWorUpdates()");
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is closed");
        }
    }

    @Override
    public void close() throws SQLException {
        this.Closed = true;
        this.RowsofResult = null;
    }

    protected void closestrm() throws SQLException {
        if (this.Strm != null) {
            try {
                this.Strm.close();
            }
            catch (IOException e) {
                throw new BQSQLException(e);
            }
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("deleteRow()");
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        throw new BQSQLException("Not implemented.findColumn(string)");
    }

    @Override
    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null || this.RowsofResult.length == 0) {
            return false;
        }
        this.Cursor = 0;
        return true;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getArray(int)");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getArray(string)");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        ByteArrayInputStream inptstrm;
        this.closestrm();
        String Value2 = this.getString(columnIndex);
        if (Value2 == null) {
            this.wasnull = true;
            this.Strm = null;
            return this.Strm;
        }
        this.wasnull = false;
        try {
            inptstrm = new ByteArrayInputStream(Value2.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new BQSQLException(e);
        }
        this.Strm = inptstrm;
        return this.Strm;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        ByteArrayInputStream inptstrm;
        this.closestrm();
        String Value2 = this.getString(columnLabel);
        if (Value2 == null) {
            this.wasnull = true;
            this.Strm = null;
            return this.Strm;
        }
        this.wasnull = false;
        try {
            inptstrm = new ByteArrayInputStream(Value2.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new BQSQLException(e);
        }
        this.Strm = inptstrm;
        return this.Strm;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String coltype = this.getMetaData().getColumnTypeName(columnIndex);
        if (coltype.equals("STRING")) {
            String Value2 = this.getString(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            try {
                return new BigDecimal(Value2);
            }
            catch (NumberFormatException e) {
                throw new BQSQLException(e);
            }
        }
        if (coltype.equals("INTEGER")) {
            int Value3 = this.getInt(columnIndex);
            if (this.wasNull()) {
                return null;
            }
            return new BigDecimal(Value3);
        }
        if (coltype.equals("FLOAT")) {
            Float Value4 = Float.valueOf(this.getFloat(columnIndex));
            if (this.wasNull()) {
                return null;
            }
            return new BigDecimal(Value4.floatValue());
        }
        if (coltype.equals("BOOLEAN")) {
            throw new NumberFormatException("Cannot format Boolean to BigDecimal");
        }
        throw new NumberFormatException("Undefined format");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex).setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBigDecimal(columnIndex, scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.closestrm();
        String Value2 = this.getString(columnIndex);
        if (Value2 == null) {
            this.wasnull = true;
            this.Strm = null;
            return this.Strm;
        }
        this.wasnull = false;
        ByteArrayInputStream inptstrm = new ByteArrayInputStream(Value2.getBytes());
        this.Strm = inptstrm;
        return this.Strm;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.closestrm();
        String Value2 = this.getString(columnLabel);
        if (Value2 == null) {
            this.wasnull = true;
            this.Strm = null;
            return this.Strm;
        }
        this.wasnull = false;
        ByteArrayInputStream inptstrm = new ByteArrayInputStream(Value2.getBytes());
        this.Strm = inptstrm;
        return this.Strm;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getBlob(int)");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getBlob(string)");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return false;
        }
        return Boolean.parseBoolean(Value2);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        try {
            return Byte.parseByte(Value2);
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getByte(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return Value2.getBytes();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getBytes(columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.closestrm();
        String Value2 = this.getString(columnIndex);
        if (Value2 == null) {
            this.wasnull = true;
            return null;
        }
        this.wasnull = false;
        StringReader rdr = new StringReader(Value2);
        return rdr;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.closestrm();
        String Value2 = this.getString(columnLabel);
        if (Value2 == null) {
            this.wasnull = true;
            return null;
        }
        this.wasnull = false;
        StringReader rdr = new StringReader(Value2);
        return rdr;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getClob(int)");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getClob(string)");
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getCursorName()");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Long value = this.getLong(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return new Date(value);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Long value = this.getLong(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return new Date(value + (long)cal.getTimeZone().getRawOffset());
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDate(columnIndex, cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(Value2);
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getDouble(columnIndex);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new BQSQLException("Not implemented.getFetchDirection()");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new BQSQLException("Not implemented.getfetchSize()");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(Value2);
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getFloat(columnIndex);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        try {
            return Integer.parseInt(Value2);
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(Value2);
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getLong(columnIndex);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.logger.debug("ResultSetMetaData getMetaData()Not implemented");
        throw new BQSQLException("Not implemented.getMetaData()");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getNClob(int");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getNClob(string)");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getObject(int,Map)");
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getObject(string,Map)");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getRef(int)");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getref(String)");
    }

    @Override
    public int getRow() throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null || this.RowsofResult.length == 0 || this.Cursor == -1 || this.Cursor > this.RowsofResult.length - 1) {
            return 0;
        }
        return this.Cursor + 1;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getRowId(int)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getRowId(String)");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return 0;
        }
        try {
            return Short.parseShort(Value2);
        }
        catch (NumberFormatException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getShort(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return new BQSQLXML(this.getString(columnIndex));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getSQLXML(columnIndex);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getString(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Long value = this.getLong(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return new Time(value);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Long value = this.getLong(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return new Time((long)cal.getTimeZone().getRawOffset() + value);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTime(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Long value = this.getLong(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return new Timestamp(value);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Long value = this.getLong(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return new Timestamp((long)cal.getTimeZone().getRawOffset() + value);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        return this.getTimestamp(columnIndex, cal);
    }

    @Override
    public int getType() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return 1004;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("Deprecated. use getCharacterStream in place of getUnicodeStream");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("Deprecated. use getCharacterStream in place of getUnicodeStream");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String Value2 = this.getString(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        try {
            return new URL(Value2);
        }
        catch (MalformedURLException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        String Value2 = this.getString(columnLabel);
        if (this.wasNull()) {
            return null;
        }
        try {
            return new URL(Value2);
        }
        catch (MalformedURLException e) {
            throw new BQSQLException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("insertRow()");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return this.RowsofResult != null && this.Cursor == this.RowsofResult.length && this.RowsofResult.length != 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return this.RowsofResult != null && this.Cursor == -1 && this.RowsofResult.length != 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.Closed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return this.Cursor == 0 && this.RowsofResult != null && this.RowsofResult.length != 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        return this.RowsofResult != null && this.Cursor == this.RowsofResult.length - 1 && this.RowsofResult.length - 1 >= 0;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null || this.RowsofResult.length == 0) {
            return false;
        }
        this.Cursor = this.RowsofResult.length - 1;
        return true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("moveToCurrentRow()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("moveToInsertRow()");
    }

    @Override
    public boolean next() throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null) {
            return false;
        }
        if (this.RowsofResult.length > this.Cursor + 1) {
            ++this.Cursor;
            return true;
        }
        this.Cursor = this.RowsofResult.length;
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null) {
            return false;
        }
        if (this.Cursor > 0) {
            --this.Cursor;
            return true;
        }
        this.Cursor = -1;
        return false;
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("refreshRow()");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.getType() == 1003) {
            throw new BQSQLException("The Type of the Resultset is TYPE_FORWARD_ONLY");
        }
        if (this.isClosed()) {
            throw new BQSQLException("This Resultset is Closed");
        }
        if (this.RowsofResult == null) {
            return false;
        }
        if (rows == 0) {
            return this.RowsofResult.length != 0 && this.Cursor < this.RowsofResult.length && this.Cursor > -1;
        }
        if (rows < 0) {
            if (this.Cursor + rows < 0) {
                this.Cursor = -1;
                return false;
            }
            this.Cursor += rows;
            return true;
        }
        if (rows + this.Cursor > this.RowsofResult.length - 1) {
            this.Cursor = this.RowsofResult.length;
            return false;
        }
        this.Cursor += rows;
        return true;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new BQSQLException("Not implemented.setFetchDirection(int)");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new BQSQLException("Not implemented.setFetchSize(int)");
    }

    public void ThrowCursorNotValidExeption() throws SQLException {
        if (this.RowsofResult == null || this.RowsofResult.length == 0) {
            throw new BQSQLException("There are no rows in this Resultset" + String.valueOf(this.Cursor) + "RowsofResult.length" + String.valueOf(this.RowsofResult.length));
        }
        if (this.Cursor >= this.RowsofResult.length || this.Cursor <= -1) {
            throw new BQSQLException("Cursor is not in a valid Position. Cursor Position is:" + String.valueOf(this.Cursor) + "RowsofResult.length" + String.valueOf(this.RowsofResult.length));
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new BQSQLException("Not implemented.unwrap(Class<T>)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new BQSQLFeatureNotSupportedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasnull;
    }
}

