/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.initializer;

import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import net.starschema.clouddb.initializer.DbUtils;
import net.starschema.clouddb.initializer.DriverShim;
import net.starschema.clouddb.initializer.ExtensionFileFilter;

public class GUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static String st_TestConnection = "Test Connection";
    private static String st_ProjectId = "Obtained from https://code.google.com/apis/console";
    private static String st_Pass = "Client secret";
    private static String st_UserName = "Client ID";
    private static String st_DriverPath = "path to the downloaded driver";
    private String jdbcUrl = "jdbc:BQDriver:";
    private JPanel contentPane;
    private JLabel lblInfoText;
    private JCheckBox checkBoxQTE;
    private JCheckBox checkBoxSA;
    private JCheckBox checkBoxIncludeUserPass;
    private JPanel j1;
    private JPanel j2;
    private JLabel tf_DriverPath;
    private JTextField tf_userName;
    private JTextField tf_pass;
    private JTextField tf_projectId;
    private JTextField label_jdbcURL_output;
    private JButton button_testConnection;
    private JTextArea queryText;
    private JTable table;
    private JScrollPane scrollPane;
    private JTextField txtBQDriver;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GUI frame = new GUI();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public GUI() {
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 909, 650);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.setTitle("Starschema JDBC initializer");
        this.contentPane.setLayout(null);
        this.j1 = new JPanel();
        this.j1.setBounds(5, 5, 878, 220);
        this.j1.setLayout(null);
        JLabel label_path = new JLabel("JDBC Driver path:");
        label_path.setBounds(10, 10, 99, 22);
        this.j1.add(label_path);
        this.getContentPane().add(this.j1);
        JLabel lblUsernameclientId = new JLabel("Username (Client ID):");
        lblUsernameclientId.setBounds(10, 38, 200, 22);
        this.j1.add(lblUsernameclientId);
        JLabel lblPasswordclientSecret = new JLabel("Password (Client secret):");
        lblPasswordclientSecret.setBounds(10, 68, 200, 22);
        this.j1.add(lblPasswordclientSecret);
        JLabel lblProjectId = new JLabel("Project ID:");
        lblProjectId.setBounds(10, 96, 200, 22);
        this.j1.add(lblProjectId);
        this.tf_DriverPath = new JLabel(st_DriverPath);
        this.tf_DriverPath.setBounds(234, 10, 380, 22);
        this.j1.add(this.tf_DriverPath);
        this.tf_userName = new JTextField(st_UserName);
        this.j1.add(this.tf_userName);
        this.tf_userName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GUI.this.tf_userName.selectAll();
            }
        });
        this.tf_userName.setBounds(234, 38, 380, 22);
        this.j1.add(this.tf_userName);
        this.tf_pass = new JTextField(st_Pass);
        this.j1.add(this.tf_pass);
        this.tf_pass.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GUI.this.tf_pass.selectAll();
            }
        });
        this.tf_pass.setBounds(234, 68, 380, 22);
        this.j1.add(this.tf_pass);
        this.tf_projectId = new JTextField(st_ProjectId);
        this.j1.add(this.tf_projectId);
        this.tf_projectId.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GUI.this.tf_projectId.selectAll();
            }
        });
        this.tf_projectId.setBounds(234, 96, 380, 22);
        this.j1.add(this.tf_projectId);
        this.checkBoxSA = new JCheckBox("Connect with service account");
        this.checkBoxSA.setBounds(620, 68, 240, 22);
        this.j1.add(this.checkBoxSA);
        this.checkBoxQTE = new JCheckBox("Enable Query Transformation Engine");
        this.checkBoxQTE.setBounds(620, 10, 250, 22);
        this.j1.add(this.checkBoxQTE);
        JLabel label_jdbcURL_text = new JLabel("The JDBC Url for the connection is:");
        label_jdbcURL_text.setBounds(10, 152, 200, 22);
        this.j1.add(label_jdbcURL_text);
        this.label_jdbcURL_output = new JTextField(this.jdbcUrl);
        this.label_jdbcURL_output.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GUI.this.label_jdbcURL_output.selectAll();
            }
        });
        this.label_jdbcURL_output.setEditable(false);
        this.label_jdbcURL_output.setBounds(234, 152, 604, 22);
        this.j1.add(this.label_jdbcURL_output);
        JButton btnGetJdbcUrl = new JButton("Get JDBC url");
        btnGetJdbcUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUI.this.ConstructJDBC();
            }
        });
        btnGetJdbcUrl.setBounds(10, 183, 200, 29);
        this.j1.add(btnGetJdbcUrl);
        this.button_testConnection = new JButton(st_TestConnection);
        this.button_testConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUI.this.TestConnection();
            }
        });
        this.button_testConnection.setBounds(220, 183, 200, 29);
        this.j1.add(this.button_testConnection);
        this.checkBoxIncludeUserPass = new JCheckBox("Include Username and Password");
        this.checkBoxIncludeUserPass.setBounds(620, 38, 331, 23);
        this.j1.add(this.checkBoxIncludeUserPass);
        JButton button_OpenDriver = new JButton("Open/Load");
        button_OpenDriver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUI.this.OpenDriver();
            }
        });
        button_OpenDriver.setBounds(120, 10, 100, 23);
        this.j1.add(button_OpenDriver);
        this.lblInfoText = new JLabel("");
        this.lblInfoText.setBounds(430, 183, 430, 29);
        this.j1.add(this.lblInfoText);
        JLabel lblJDBCDriverName = new JLabel("JDBC Drivers Class Name");
        lblJDBCDriverName.setBounds(10, 129, 200, 14);
        this.j1.add(lblJDBCDriverName);
        this.txtBQDriver = new JTextField();
        this.txtBQDriver.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                GUI.this.txtBQDriver.selectAll();
            }
        });
        this.txtBQDriver.setEditable(false);
        this.txtBQDriver.setText("net.starschema.clouddb.jdbc.BQDriver");
        this.txtBQDriver.setBounds(234, 124, 380, 20);
        this.j1.add(this.txtBQDriver);
        this.txtBQDriver.setColumns(10);
        JPanel panel = new JPanel();
        panel.setBounds(5, 236, 878, 365);
        this.contentPane.add(panel);
        panel.setLayout(null);
        JButton btnNewButton = new JButton("Run Query");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUI.this.runQuery();
            }
        });
        btnNewButton.setBounds(480, 0, 104, 32);
        panel.add(btnNewButton);
        JLabel lblDriverTesterV = new JLabel("Driver Tester v1, if you want to use publicdata: turn the Query Transform off.");
        lblDriverTesterV.setBounds(10, 9, 604, 14);
        panel.add(lblDriverTesterV);
        this.queryText = new JTextArea();
        this.queryText.setBounds(10, 35, 858, 100);
        panel.add(this.queryText);
        this.queryText.setColumns(10);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBounds(10, 146, 858, 208);
        this.table = new JTable();
        this.scrollPane.setViewportView(this.table);
        panel.add(this.scrollPane);
        this.j2 = new JPanel();
        this.j2.setBounds(5, 281, 624, 176);
        this.j2.setLayout(new GridLayout(0, 2));
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("starlogo.png");
        BufferedImage img = null;
        try {
            img = ImageIO.read(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setIconImage(img);
    }

    private boolean validParameters() {
        String sequence = ".,;:_?";
        if (this.tf_userName.getText().contains(" ")) {
            this.lblInfoText.setText("UserName can't contain \"space\"");
            return false;
        }
        if (!this.tf_userName.getText().endsWith(".apps.googleusercontent.com")) {
            this.lblInfoText.setText("Username must end with \".apps.googleusercontent.com\"");
            return false;
        }
        if (this.checkBoxSA.isSelected()) {
            File file = new File(this.tf_pass.getText());
            if (!file.exists()) {
                this.lblInfoText.setText("Password must be a valid path to the keyfile!");
                return false;
            }
        } else {
            for (char myChar : this.tf_pass.getText().toCharArray()) {
                String myCharString = String.valueOf(myChar);
                if (!sequence.contains(myCharString)) continue;
                this.lblInfoText.setText("password can't contain: " + sequence);
                return false;
            }
            if (this.tf_pass.getText().contains(" ")) {
                this.lblInfoText.setText("password can't contain \"space\"");
                return false;
            }
        }
        if (this.tf_projectId.getText().contains(" ")) {
            this.lblInfoText.setText("Project Id can't contain \"space\"");
            return false;
        }
        this.lblInfoText.setText("");
        return true;
    }

    private void ConstructJDBC() {
        if (!this.validParameters()) {
            return;
        }
        this.jdbcUrl = "jdbc:BQDriver:";
        this.jdbcUrl = this.jdbcUrl + this.tf_projectId.getText().replace(":", "%3A");
        if (this.checkBoxQTE.isSelected()) {
            this.jdbcUrl = this.jdbcUrl + "?transformQuery=true";
        }
        if (this.checkBoxSA.isSelected()) {
            this.jdbcUrl = this.jdbcUrl + "?withServiceAccount=true";
        }
        if (this.checkBoxIncludeUserPass.isSelected()) {
            this.jdbcUrl = this.jdbcUrl + "?user=" + this.tf_userName.getText();
            this.jdbcUrl = this.jdbcUrl + "?password=" + this.tf_pass.getText();
        }
        this.label_jdbcURL_output.setText(this.jdbcUrl);
    }

    private void OpenDriver() {
        JFileChooser fileDialog = new JFileChooser();
        ExtensionFileFilter jarFilter = new ExtensionFileFilter(new String("jar"), "Jar Files");
        for (FileFilter filefilter : fileDialog.getChoosableFileFilters()) {
            fileDialog.removeChoosableFileFilter(filefilter);
        }
        fileDialog.addChoosableFileFilter(jarFilter);
        try {
            fileDialog.setCurrentDirectory(new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath()));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        File defaultDriver = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        fileDialog.setSelectedFile(defaultDriver);
        int option = fileDialog.showOpenDialog(this);
        if (option == 0) {
            this.tf_DriverPath.setText(fileDialog.getSelectedFile() != null ? fileDialog.getSelectedFile().getPath() : st_DriverPath);
        } else {
            this.tf_DriverPath.setText(st_DriverPath);
        }
    }

    private void TestConnection() {
        if (!this.validParameters()) {
            return;
        }
        String samplesql = "SELECT corpus, corpus_date FROM publicdata:samples.shakespeare GROUP BY corpus, corpus_date ORDER BY corpus_date DESC LIMIT 1";
        Thread runquery = new Thread(new Runnable(){

            @Override
            public void run() {
                GUI.this.connectAndRunQuery(false, "SELECT corpus, corpus_date FROM publicdata:samples.shakespeare GROUP BY corpus, corpus_date ORDER BY corpus_date DESC LIMIT 1");
            }
        });
        runquery.start();
        this.lblInfoText.setText("Connection testing...");
    }

    private void runQuery() {
        if (!this.validParameters()) {
            return;
        }
        Thread runquery = new Thread(new Runnable(){

            @Override
            public void run() {
                GUI.this.connectAndRunQuery(GUI.this.checkBoxQTE.isSelected(), GUI.this.queryText.getText());
            }
        });
        runquery.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndRunQuery(boolean QTE, String query) {
        Connection con = null;
        try {
            URL[] myJars = new URL[]{new URL("file:///" + this.tf_DriverPath.getText())};
            String classname = "net.starschema.clouddb.jdbc.BQDriver";
            URLClassLoader child = new URLClassLoader(myJars, this.getClass().getClassLoader());
            Driver d = (Driver)Class.forName(classname, true, child).newInstance();
            DriverManager.registerDriver(new DriverShim(d));
            String URL2 = "jdbc:BQDriver:" + this.tf_projectId.getText().replace(":", "%3A");
            if (QTE) {
                URL2 = URL2 + "?transformQuery=true";
            }
            con = DriverManager.getConnection(URL2, this.tf_userName.getText(), this.tf_pass.getText());
        }
        catch (Exception e) {
            this.lblInfoText.setText("We failed at making connection " + e.getLocalizedMessage());
            return;
        }
        ResultSet myResult = null;
        try {
            myResult = con.createStatement().executeQuery(query);
        }
        catch (SQLException e) {
            this.lblInfoText.setText("We failed at running statement connection " + e.getLocalizedMessage());
            return;
        }
        try {
            if (myResult.last()) {
                this.lblInfoText.setText("Connection was successfull");
                this.table.setModel(DbUtils.resultSetToTableModel(myResult));
                this.table.setVisible(true);
                this.table.setAutoscrolls(true);
            }
        }
        catch (SQLException e) {
            this.lblInfoText.setText("No results " + e.getLocalizedMessage());
            return;
        }
        finally {
            try {
                myResult.close();
                myResult = null;
            }
            catch (SQLException se) {
                myResult = null;
            }
        }
    }
}

