% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataFilter.R
\name{dataFilter}
\alias{dataFilter}
\alias{dataFilterUI}
\alias{dataFilterServer}
\title{Shiny module for filtering data}
\usage{
dataFilterUI(id)

dataFilterServer(id, data = reactive(NULL), hide = FALSE, hover_text = NULL)
}
\arguments{
\item{id}{unique identifier for the module to prevent namespace clashes when
making multiple calls to this shiny module.}

\item{data}{an array wrapped in \code{reactive()} containing the data to be
filtered.}

\item{hide}{logical indicating whether the data filtering user interface
should be hidden from the user, set to FALSE by default.}

\item{hover_text}{text to display on download button when user hovers cursor
over button, set to NULL by default to turn off hover text.}
}
\value{
a list of reactive objects containing the filtered \code{data} and
indices for filtered \code{rows}.
}
\description{
Shiny module for filtering data
}
\examples{
if (interactive()) {
  library(shiny)
  library(rhandsontable)
  library(shinyjs)

  ui <- fluidPage(
    useShinyjs(),
    dataInputUI("input1"),
    dataFilterUI("filter1"),
    rHandsontableOutput("data1")
  )

  server <- function(input,
                     output,
                     session) {
    data_input <- dataInputServer("input1")
    
    # list with slots data and rows (indices)
    data_filter <- dataFilterServer("filter1",
      data = data_input
    )

    output$data1 <- renderRHandsontable({
      if (!is.null(data_filter$data())) {
        rhandsontable(data_filter$data())
      }
    })
    
  }

  shinyApp(ui, server)
}

}
\author{
Dillon Hammill, \email{Dillon.Hammill@anu.edu.au}
}
