## TODO:
## multiple DVH/constraint plots with -> custom renderPlotList(), plotListOutput()
## footer
source("helper.R")

shinyUI(fluidPage(
    #theme="bootstrap.css",
    titlePanel("Analyze dose-volume histograms using DVHmetrics"),
    sidebarLayout(
        sidebarPanel(width=3,
            conditionalPanel(condition="input.task == 'DVH data'",
                radioButtons("DVHin", label=h4("Enter data"),
                             list("Use built-in data"=1,
                                  "Upload DVH file"=2)),
                conditionalPanel(condition="input.DVHin == '2'",
                                 h5("Upload DVH file: "),
                                 radioButtons("DVHtype", "DVH file format:",
                                              list("Eclipse"=1, "CadPlan"=2, "MasterPlan"=3,
                                                   "Pinnacle3"=4, "Monaco"=5, "HiArt"=6,
                                                   "RayStation"=7, "ProSoma"=8, "PRIMO"=9)),
                                 fileInput("DVHupload", "Select DVH file:", multiple=TRUE),
                                 # radioButtons("fileenc", "File encoding:",
                                 #              list("Default"=1, "UTF-8"=2, "UTF-8-BOM"=3)),
                                 radioButtons("DVHplanInfo", "Information encoded in plan:",
                                              list("None"=1, "Prescribed dose"=2)),
                                 checkboxGroupInput("DVHreadOpts", label=NULL,
                                                    choices=c("Add to existing data"="DVHadd",
                                                              "Use Course for ID"="DVHcourse"))),
                actionButton("applyData", "Apply"),
                radioButtons("DVHverbose", "",
                             list("Short info on DVHs"=1,
                                  "Detailed info on DVHs"=2))
            ),
            conditionalPanel(condition="input.task == 'Metrics'",
                h4("Define metrics"),
                textInput("metrInput", "Metric(s):", value=c("DMEAN, D1cc, V10%")),
                #tags$textarea(id="defMetricsMult", rows=2, cols=10, ""),
                #actionButton('clearText_button','Clear metrics'),
                #radioButtons("metrInterp", label=h5("DVH interpolation"),
                #             list("Linear"=1,
                #                  "Monotone spline"=2,
                #                  "Local polynomial"=3)),
                checkboxInput("metrEUDparam", "Show EUD params ...", FALSE),
                conditionalPanel(condition="input.metrEUDparam == true",
                    textInput("metrEUDa", h5("exponent a"), value=""),
                    textInput("metrEUDfd", h5("fraction dose"), value=""),
                    textInput("metrEUDab", h5("alpha/beta ratio"), value="")
                ),
                checkboxInput("metrNTCPparam", "Show (N)TCP params ...", FALSE),
                conditionalPanel(condition="input.metrNTCPparam == true",
                    radioButtons("metrNTCPtype", h5("(N)TCP Model"),
                                 list("Probit (Lyman KB)"=1,
                                      "Logit (Niemierko)"=2,
                                      "Probit (Kaellman)"=3)),
                    textInput("metrNTCPtd50", h5("T(C)D50"), value=""),
                    textInput("metrNTCPn", h5("n (=1 / EUD-a)"), value=""),
                    conditionalPanel(condition="input.metrNTCPtype == '1'",
                        textInput("metrNTCPm", h5("Lyman m"), value="")
                    ),
                    conditionalPanel(condition="input.metrNTCPtype != '1'",
                        textInput("metrNTCPgamma50", h5("Logit/Poisson gamma50"), value="")
                    )
                ),
                uiOutput("metrSelPat"),
                uiOutput("metrSelStruct"),
                selectizeInput("metrSortBy", label=h5("Sort output table by:"),
                              choices=c("Value"=1,
                                        "Structure"=2,
                                        "Metric"=3,
                                        "Patient ID"=4),
                              multiple=TRUE)#,
                              #options=c(placeholder='Click to select variables'))
            ),
            conditionalPanel(condition="input.task == 'Show DVH'",
                h4("Plot options"),
                radioButtons("plotByPat", label=h5("Plot by patient or by structure"),
                             list("By patient"=1,
                                  "By structure"=2)),
                uiOutput("plotSelPat"),
                uiOutput("plotSelStruct"),
                radioButtons("plotPlotVol", label=h5("Plot relative/absolute volume"),
                             list("Relative volume"=1,
                                  "Absolute volume"=2)),
                radioButtons("plotType", label=h5("DVH type"),
                             list("Cumulative"=1,
                                  "Differential"=2)),
                checkboxInput("plotMSD", "Show M + SD areas", FALSE),
                sliderInput("plotThreshVol", label=h5("Threshold volume"),
                            min=0, max=100, value=1)
            ),
            conditionalPanel(condition="input.task == 'Check constraints'",
                radioButtons("constrIn", label=h4("Define constraints"),
                             list("Use built-in constraints"=1,
                                  "Upload constraints"=2,
                                  "Paste constraints"=3)),
                conditionalPanel(condition="input.constrIn == '2'",
                                 h5("Upload constraints: "),
                                 fileInput("constrUpload", "Select constraint file:", multiple=FALSE),
                                 radioButtons("constrDec", "Decimal separator:",
                                              list("."=1, ","=2)),
                                 radioButtons("constrSep", "Column separator:",
                                              list("\\t (tab)"=1, "' ' (space)"=2, ", (comma)"=3, "; (semicolon)"=4),
                                              selected=2)),
                conditionalPanel(condition="input.constrIn == '3'",
                                 h5("Paste constraints:"),
                                 tags$textarea(id="constrPaste", rows=4, cols=10, ""),
                                 radioButtons("constrPasteDec", "Decimal separator:",
                                              list("."=1, ","=2)),
                                 radioButtons("constrPasteSep", "Column separator:",
                                              list("\\t (tab)"=1, "' ' (space)"=2, ", (comma)"=3, "; (semicolon)"=4),
                                              selected=2)),
                actionButton("applyConstraints", "Apply"),
                #radioButtons("constrInterp", label=h5("DVH interpolation"),
                #             list("Linear"=1,
                #                  "Monotone spline"=2,
                #                  "Local polynomial"=3)),
                checkboxInput("constrEUDparam", "Show EUD params ...", FALSE),
                conditionalPanel(condition="input.constrEUDparam == true",
                    textInput("constrEUDa", h5("exponent a"), value=""),
                    textInput("constrEUDfd", h5("fraction dose"), value=""),
                    textInput("constrEUDab", h5("alpha/beta ratio"), value="")
                ),
                checkboxInput("constrNTCPparam", "Show (N)TCP params ...", FALSE),
                conditionalPanel(condition="input.constrNTCPparam == true",
                    radioButtons("constrNTCPtype", h5("(N)TCP Model"),
                                 list("Probit (Lyman KB)"=1,
                                      "Logit (Niemierko)"=2,
                                      "Probit (Kaellman)"=3)),
                    textInput("constrNTCPtd50", h5("T(C)D50"), value=""),
                    textInput("constrNTCPn", h5("n (=1 / EUD-a)"), value=""),
                    conditionalPanel(condition="input.constrNTCPtype == '1'",
                        textInput("constrNTCPm", h5("Lyman m"), value="")
                    ),
                    conditionalPanel(condition="input.constrNTCPtype != '1'",
                        textInput("constrNTCPgamma50", h5("Logit/Poisson gamma50"), value="")
                    )
                ),
                h4("Output table options"),
                checkboxInput("constrSemSign", "Semantic negative sign", TRUE),
                selectizeInput("constrOut", label=h5("Select table columns"),
                               choices=constrOut, multiple=TRUE,
                               selected=c("1", "2", "3", "4", "5", "7", "9", "10", "11"),
                               width="100%"),
                selectizeInput("constrSortBy", label=h5("Sort output table by:"),
                               choices=c("Compliance"=1,
                                         "Distance"=2,
                                         "Delta volume"=3,
                                         "Delta dose"=4,
                                         "Observed"=5,
                                         "Constraint"=6,
                                         "Patient ID"=7,
                                         "Structure"=8),
                               multiple=TRUE)#,
                               #options=c(placeholder='Click to select variables'))
            ),
            conditionalPanel(condition="input.task == 'Show constraints'",
                h4("Plot options"),
                radioButtons("constrByPat", label=h5("Plot by patient or by structure"),
                             list("By patient"=1,
                                  "By structure"=2)),
                radioButtons("constrPlotVol", label=h5("Plot relative/absolute volume"),
                             list("Relative volume"=1,
                                  "Absolute volume"=2)),
                sliderInput("constrThreshVol", label=h5("Threshold volume"),
                            min=0, max=100, value=1)
            ),
            conditionalPanel(condition="input.task == 'BED/EQD2'",
                h4("Conversion type"),
                selectInput("BEDtype", label=NULL,
                            choices=list("BED"=1,
                                         "EQD2"=2,
                                         "Isoeffective dose"=3),
                            selected=1),
                conditionalPanel(condition="(input.BEDtype == '1') || (input.BEDtype == '2')",
                                 h4("Input"),
                                 textInput("BED_BED_D", h5("Total Dose"),
                                           value=c("50")),
                                 textInput("BED_BED_FD", h5("Fractional Dose"),
                                           value=c("1.5 2 2.5")),
                                 textInput("BED_BED_FN", h5("Number of fractions"),
                                           value=""),
                                 textInput("BED_BED_AB", h5("alpha/beta ratio"),
                                           value="2")
                ),
                conditionalPanel(condition="input.BEDtype == '3'",
                                 h4("Input"),
                                 textInput("BED_IED_D1", h5("Total Dose 1"),
                                           value=c("50")),
                                 textInput("BED_IED_D2", h5("Total Dose 2"),
                                           value=""),
                                 textInput("BED_IED_FD1", h5("Fractional Dose 1"),
                                           value=c("1.5 2 2.5")),
                                 textInput("BED_IED_FD2", h5("Fractional Dose 2"),
                                           value=c("2")),
                                 textInput("BED_IED_FN1", h5("Number of fractions 1"),
                                           value=""),
                                 textInput("BED_IED_FN2", h5("Number of fractions 2"),
                                           value=""),
                                 textInput("BED_IED_AB", h5("alpha/beta ratio"),
                                           value="2")
                )
                ),
            conditionalPanel(condition="input.task == 'About'",
                h4("Background info")
            )
        ),

        mainPanel(
            tabsetPanel(
                tabPanel("DVH data",
                    h6("Information from imported DVH file(s)"),
                    verbatimTextOutput("DVHinfo")
                ),
                tabPanel("Metrics",
                    h6("Calculate metrics"),
                    dataTableOutput("metrics"),
                    downloadButton("saveMetrics", "Save as text file"),
                    inputPanel(
                    radioButtons("saveMetrDec", "Decimal separator:",
                                 list("."=1, ","=2)),
                    radioButtons("saveMetrSep", "Column separator:",
                                 list("\\t (tab)"=1, "' ' (space)"=2, ", (comma)"=3, "; (semicolon)"=4)))
                ),
                tabPanel("Show DVH",
                    h6("Show cumulative DVH diagrams"),
                    downloadButton("saveDVHPDF", "Save as PDF"),
                    downloadButton("saveDVHJPG", "Save as JPEGs (zipped to one file)"),
                    #plotOutput("DVHplotOrg"),
                    uiOutput("DVHplot"),
                    downloadButton("saveDVHMSD", "Save DVH Mean + SD as text file"),
                    inputPanel(
                    radioButtons("saveDVHDec", "Decimal separator:",
                                 list("."=1, ","=2)),
                    radioButtons("saveDVHSep", "Column separator:",
                                 list("\\t (tab)"=1, "' ' (space)"=2, ", (comma)"=3, "; (semicolon)"=4)))
                ),
                tabPanel("Check constraints",
                    h6("Check constraints"),
                    dataTableOutput("constraints"),
                    downloadButton("saveConstrTxt", "Save as text file"),
                    inputPanel(
                    radioButtons("saveConstrDec", "Decimal separator:",
                                 list("."=1, ","=2)),
                    radioButtons("saveConstrSep", "Column separator:",
                                 list("\\t (tab)"=1, "' ' (space)"=2, ", (comma)"=3, "; (semicolon)"=4)))
                ),
                tabPanel("Show constraints",
                    h6("Show constraints in DVH diagrams"),
                    downloadButton("saveConstrPDF", "Save as PDF"),
                    downloadButton("saveConstrJPG", "Save as JPEGs (zipped to one file)"),
                    #plotOutput("constraintPlotOrg"),
                    uiOutput("constraintPlot")
                ),
                tabPanel("BED/EQD2",
                    h6("BED / EQD2 / Isoeffective dose calculation"),
                    conditionalPanel(condition="input.BEDtype == '1'",
                        h5("BED")
                    ),
                    conditionalPanel(condition="input.BEDtype == '2'",
                        h5("EQD2")
                    ),
                    conditionalPanel(condition="input.BEDtype == '3'",
                        h5("Isoeffective dose")
                    ),

                    verbatimTextOutput("BED")
                ),
                tabPanel("About",
                    includeHTML("ABOUT.html")
                ),

                id="task"
            )
        )
    )
))
