% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.trimws.character.R
\name{dt.trimws.character}
\alias{dt.trimws.character}
\title{dt.trimws.character}
\usage{
dt.trimws.character(
  dt.name,
  the.variables = ".",
  the.filter = NULL,
  grouping.variables = NULL,
  sortby.group = TRUE,
  table.format = "wide",
  add.function.name = FALSE,
  return.as = "result",
  envir = parent.frame(),
  which = c("both", "left", "right"),
  whitespace = "[ \\t\\r\\n]",
  convert.factor = FALSE,
  ...
)
}
\arguments{
\item{dt.name}{a character value specifying the name of a data.frame or data.table object.}

\item{the.variables}{a character vector specifying the variables that we want to apply a function to.  Only values that exist in names(dat) will be used; other values in the.variables will be excluded from the calculation.  When the.variables includes ".", then all values in names(dat) will be selected.  Values of the.variables that also exist in grouping.variables will be excluded from the.variables (but grouped by these values).}

\item{the.filter}{a character value, logical value, or expression stating the logical operations to be performed in filtering the data prior to calculating the.function.}

\item{grouping.variables}{a character vector specifying variables to group by in performing the computation.  Only values that exist in names(dat) will be used.}

\item{sortby.group}{a logical value to specify if the sorting functionality needs to be applied or not}

\item{table.format}{a character vector specifying if table should be in a wide format or a tall format}

\item{add.function.name}{a logical value specifying whether the name of the function applied should be appended to the column names in the resulting table.}

\item{return.as}{describes whether return should be result, code or mixture of both}

\item{envir}{the environment in which the code would be evaluated; parent.frame() by default.}

\item{which}{both, left or right}

\item{whitespace}{encoded whitespace}

\item{convert.factor}{logical value specifying if variable needs to be converted to a factor before calculations}

\item{...}{additional arguments to be passed}
}
\value{
The function's output varies based on the 'return.as' parameter:
- If 'return.as' is "result", it returns a modified version of the input data frame or data table with specified variables having their leading, trailing, or both types of whitespace trimmed according to the 'which' parameter. This is performed after any set filtering and subgrouping, with options for trimming specified by 'whitespace' and 'convert.factor'.
- If 'return.as' is "code", it provides the R code or expressions designed to execute this whitespace trimming, allowing users to review or implement the modifications independently.
- If another value is specified for 'return.as', the output might include both the adjusted data and the corresponding R code, depending on the function’s configuration.

This function is crucial for cleaning character data, ensuring consistency, and preparing data for analysis by removing unwanted whitespace from the specified variables.
}
\description{
wrapper function
}
