% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{rowaggregate.DTSg}
\alias{rowaggregate.DTSg}
\alias{rowaggregate}
\title{Aggregate Values Row-wise}
\usage{
\method{rowaggregate}{DTSg}(
  x,
  resultCols,
  fun,
  ...,
  cols = self$cols(class = "numeric"),
  clone = getOption("DTSgClone")
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{resultCols}{A character vector either of length one (names of
\code{fun} are appended in the case one or more functions are provided) or
the same length as \code{fun}.}

\item{fun}{A summary function, (named) \code{\link{list}} of summary
functions or (named) character vector specifying summary functions applied
row-wise to all the values of the specified columns. The return value(s)
must be of length one. See details for further information.}

\item{\dots}{Further arguments passed on to \code{fun}.}

\item{cols}{A character vector specifying the columns to apply \code{fun} to.}

\item{clone}{A logical specifying if the object is modified in place or if a
clone (copy) is made beforehand.}
}
\value{
Returns a \code{\link{DTSg}} object.
}
\description{
Applies one or more provided summary functions row-wise to selected columns
 of a \code{\link{DTSg}} object.
}
\details{
Some examples for \code{fun} are as follows:
 \itemize{
   \item \code{\link{mean}}
   \item \code{\link{list}(min = \link{min}, max = \link{max})}
   \item \code{c(sd = "\link{sd}", var = "\link{var}")}
 }
 A list or character vector must have names in case more than one summary
 function is provided.
}
\examples{
# new DTSg object
DT <- data.table::data.table(
  date = flow$date,
  flow1 = flow$flow - rnorm(nrow(flow)),
  flow2 = flow$flow,
  flow3 = flow$flow + rnorm(nrow(flow))
)
x <- DTSg$new(values = DT)

# mean and standard deviation of multiple measurements per timestamp
## R6 method
x$rowaggregate(resultCols = "flow", fun = list(mean = mean, sd = sd))

## S3 method
rowaggregate(x = x, resultCols = "flow", fun = list(mean = mean, sd = sd))

}
\seealso{
\code{\link{DTSg}}, \code{\link{list}}, \code{\link{cols}}
}
