% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTAT-package.R
\docType{package}
\name{DTAT-package}
\alias{DTAT-package}
\alias{DTAT}
\title{Dose Titration Algorithm Tuning: a Framework for Dose Individualization
in Drug Development}
\description{
Dose Titration Algorithm Tuning (DTAT) is a methodologic framework
allowing dose individualization to be conceived as a continuous learning process
that begins in early-phase clinical trials and continues throughout drug development,
on into clinical practice.
This package includes code that researchers may use to reproduce or extend key results
of the DTAT research programme, plus tools for trialists to design and simulate a
'3+3/PC' dose-finding study. Please see Norris (2017) \doi{10.12688/f1000research.10624.3}
and Norris (2017) \doi{10.1101/240846}.
}
\references{
\enumerate{
\item Norris DC. Dose Titration Algorithm Tuning (DTAT) should supersede
\sQuote{the} Maximum Tolerated Dose (MTD) in oncology dose-finding trials.
\emph{F1000Research}. 2017;6:112. \doi{10.12688/f1000research.10624.3}.
\url{https://f1000research.com/articles/6-112/v3}
\item Norris DC. Costing \sQuote{the} MTD. \emph{bioRxiv}. August 2017:150821.
\doi{10.1101/150821}.
\url{http://www.biorxiv.org/content/early/2017/08/22/150821}
\item Norris DC. Precautionary Coherence Unravels Dose Escalation Designs.
\emph{bioRxiv}. December 2017:240846. \doi{10.1101/240846}.
\url{https://www.biorxiv.org/content/early/2017/12/29/240846}
\item Norris DC. One-size-fits-all dosing in oncology wastes money, innovation
and lives. \emph{Drug Discov Today}. 2018;23(1):4-6.
\doi{10.1016/j.drudis.2017.11.008}.
\url{https://www.sciencedirect.com/science/article/pii/S1359644617303586}
\item Norris DC. Costing \sQuote{the} MTD ... in 2-D. \emph{bioRxiv}. July 2018:370817.
\doi{10.1101/370817}.
\url{https://www.biorxiv.org/content/early/2018/07/17/370817}
}
}
\author{
David C. Norris
}
