% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Survey.Design.R
\docType{class}
\name{Survey.Design-class}
\alias{Survey.Design-class}
\title{S4 Class "Survey.Design"}
\description{
Virtual Class "Survey.Design"
}
\details{
Virtual Class \code{"Survey.Design"} is an S4 class detailing the survey 
design. Currently only line transect designs are implemented and transects 
from these designs must be generated using the Distance software in 
advance.
}
\section{Slots}{

\describe{
\item{\code{design.axis}}{Object of class \code{"numeric"}; the angle of
the design axis.}

\item{\code{spacing}}{Object of class \code{"numeric"}; the spacing of
the design.}

\item{\code{region.obj}}{Object of class \code{"character"}; The name of
the region which the survey design has been made for.}

\item{\code{plus.sampling}}{Object of class \code{"logical"}; Whether 
a plus sampling protocol is to be used.}

\item{\code{path}}{Object of class \code{"character"}; Describing the
folder where the shapefiles containing the transects are located.}

\item{\code{filenames}}{Object of class \code{"character"}; stores the 
filenames of the transect shapefiles. These are automatically added
when the object is created using all the files in the specified path.}

\item{\code{file.index}}{Object of class \code{"numeric"}; Keeps track
of which shapefile is to be loaded.}
}}

\seealso{
\code{\link{make.design}}
}
\keyword{classes}
