% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.dsspMod}
\alias{predict.dsspMod}
\title{Predictions from a model with new data.}
\usage{
\method{predict}{dsspMod}(object, newdata, ...)
}
\arguments{
\item{object}{a fitted dsspMod object.}

\item{newdata}{a data frame for which to evaluate predictions.}

\item{...}{optional and ignored arguments.}
}
\value{
returns matrix with posterior densities for each row in the input data.
}
\description{
Predictions from a model with new data.
}
\examples{
data("meuse.all", package = "gstat")
sp::coordinates(meuse.all) <- ~ x + y
meuse.fit <- DSSP(
  formula = log(zinc) ~ 1, data = meuse.all[1:155, ], N = 100, function(x) -2 * log(1 + x),
  pars = c(0.001, 0.001)
)
preds <- predict(meuse.fit, meuse.all[156:164, ])
}
