% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cul.R
\name{read_cul}
\alias{read_cul}
\title{Reads parameters from a single DSSAT cultivar parameter file (*.CUL)}
\usage{
read_cul(file_name, col_types = NULL, col_names = NULL,
  left_justified = c("VAR#", "VARNAME\\\\.*", "VAR-NAME\\\\.*",
  "VRNAME\\\\.*"))
}
\arguments{
\item{file_name}{a character vector of length one that contains the name
of a single DSSAT output file}

\item{col_types}{One of NULL, a cols() specification, or a string.
See \code{\link[readr]{read_fwf}} or \code{vignette("readr")} for
more details.}

\item{col_names}{A character vector of column names; primarily
helpful for cases where there are no white spaces between column
names within the header line}

\item{left_justified}{A character vector of column names that
should be left justified}
}
\value{
a tibble containing the data from the raw DSSAT output
}
\description{
Reads parameters from a single DSSAT cultivar parameter file (*.CUL)
}
\examples{

# Extract file path for sample cultivar file path
sample_cul_file <- system.file('extdata','SAMPLE.CUL',package='DSSAT')

# Read sample cultivar file
cul <- read_cul(sample_cul_file)


}
