% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSLiteServer.R
\docType{class}
\name{DSLiteServer}
\alias{DSLiteServer}
\title{Lightweight DataSHIELD server-side component}
\description{
DSLiteServer mimics a DataSHIELD server by holding datasets and exposing
DataSHIELD-like functions: aggregate and assign. A DataSHIELD session is a R
environment where the assignment and the operations happen.
}
\seealso{
Other server-side items: 
\code{\link{newDSLiteServer}()}
}
\concept{server-side items}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DSLiteServer$new()}}
\item \href{#method-config}{\code{DSLiteServer$config()}}
\item \href{#method-profile}{\code{DSLiteServer$profile()}}
\item \href{#method-strict}{\code{DSLiteServer$strict()}}
\item \href{#method-home}{\code{DSLiteServer$home()}}
\item \href{#method-workspaces}{\code{DSLiteServer$workspaces()}}
\item \href{#method-workspace_save}{\code{DSLiteServer$workspace_save()}}
\item \href{#method-workspace_rm}{\code{DSLiteServer$workspace_rm()}}
\item \href{#method-aggregateMethods}{\code{DSLiteServer$aggregateMethods()}}
\item \href{#method-aggregateMethod}{\code{DSLiteServer$aggregateMethod()}}
\item \href{#method-assignMethods}{\code{DSLiteServer$assignMethods()}}
\item \href{#method-assignMethod}{\code{DSLiteServer$assignMethod()}}
\item \href{#method-options}{\code{DSLiteServer$options()}}
\item \href{#method-option}{\code{DSLiteServer$option()}}
\item \href{#method-newSession}{\code{DSLiteServer$newSession()}}
\item \href{#method-hasSession}{\code{DSLiteServer$hasSession()}}
\item \href{#method-getSession}{\code{DSLiteServer$getSession()}}
\item \href{#method-getSessionIds}{\code{DSLiteServer$getSessionIds()}}
\item \href{#method-getSessionData}{\code{DSLiteServer$getSessionData()}}
\item \href{#method-closeSession}{\code{DSLiteServer$closeSession()}}
\item \href{#method-tableNames}{\code{DSLiteServer$tableNames()}}
\item \href{#method-hasTable}{\code{DSLiteServer$hasTable()}}
\item \href{#method-resourceNames}{\code{DSLiteServer$resourceNames()}}
\item \href{#method-hasResource}{\code{DSLiteServer$hasResource()}}
\item \href{#method-symbols}{\code{DSLiteServer$symbols()}}
\item \href{#method-symbol_rm}{\code{DSLiteServer$symbol_rm()}}
\item \href{#method-assignTable}{\code{DSLiteServer$assignTable()}}
\item \href{#method-assignResource}{\code{DSLiteServer$assignResource()}}
\item \href{#method-assignExpr}{\code{DSLiteServer$assignExpr()}}
\item \href{#method-aggregate}{\code{DSLiteServer$aggregate()}}
\item \href{#method-clone}{\code{DSLiteServer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create new DSLiteServer instance. See \link{defaultDSConfiguration} function for including or excluding packages
when discovering the DataSHIELD configuration from the DataSHIELD server-side packages (meta-data from the DESCRIPTION files).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$new(
  tables = list(),
  resources = list(),
  config = DSLite::defaultDSConfiguration(),
  strict = TRUE,
  home = file.path(tempdir(), ".dslite"),
  profile = "default"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tables}}{A named list of data.frames representing the harmonized tables.}

\item{\code{resources}}{A named list of \code{resourcer::Resource} objects representing accessible data or computation resources.}

\item{\code{config}}{The DataSHIELD configuration. Default is to discover it from the DataSHIELD server-side R packages.}

\item{\code{strict}}{Logical to specify whether the DataSHIELD configuration must be strictly applied. Default is TRUE.}

\item{\code{home}}{Folder location where are located the session work directory and where to read and dump workspace images.}

\item{\code{profile}}{The DataSHIELD profile name, used to give a name to the DS configuration. Default is "default".
Default is in a hidden folder of the R session's temporary directory.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A DSLiteServer object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-config"></a>}}
\if{latex}{\out{\hypertarget{method-config}{}}}
\subsection{Method \code{config()}}{
Get or set the DataSHIELD configuration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$config(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The DataSHIELD configuration: aggregate/assign methods in data frames and a named list of options.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The DataSHIELD configuration, if no parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-profile"></a>}}
\if{latex}{\out{\hypertarget{method-profile}{}}}
\subsection{Method \code{profile()}}{
Get or set the DataSHIELD profile name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$profile(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The DataSHIELD profile name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The DataSHIELD profile, if no parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strict"></a>}}
\if{latex}{\out{\hypertarget{method-strict}{}}}
\subsection{Method \code{strict()}}{
Get or set the level of strictness (stop when function call is not configured)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$strict(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The \code{strict} logical field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The strict field if no parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-home"></a>}}
\if{latex}{\out{\hypertarget{method-home}{}}}
\subsection{Method \code{home()}}{
Get or set the home folder location where are located the session work directories and where to read and dump workspace images.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$home(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The path to the home folder.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The home folder path if no parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-workspaces"></a>}}
\if{latex}{\out{\hypertarget{method-workspaces}{}}}
\subsection{Method \code{workspaces()}}{
List the saved workspaces in the \code{home} folder.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$workspaces(prefix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{Filter workspaces starting with provided prefix (optional).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-workspace_save"></a>}}
\if{latex}{\out{\hypertarget{method-workspace_save}{}}}
\subsection{Method \code{workspace_save()}}{
Save the session's workspace image identified by the \code{sid} identifier
with the provided \code{name} in the \code{home} folder.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$workspace_save(sid, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid, }}{Session ID}

\item{\code{name}}{The name to be given to the workspace's image.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-workspace_rm"></a>}}
\if{latex}{\out{\hypertarget{method-workspace_rm}{}}}
\subsection{Method \code{workspace_rm()}}{
Remove the workspace image with the provided \code{name} from the \code{home} folder.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$workspace_rm(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the workspace.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-aggregateMethods"></a>}}
\if{latex}{\out{\hypertarget{method-aggregateMethods}{}}}
\subsection{Method \code{aggregateMethods()}}{
Get or set the aggregate methods.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$aggregateMethods(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A \code{data.frame} with columns: \code{name} (the client function call),
\code{value} (the translated server call), \code{package} (relevant when extracted from a DataSHIELD server-side package),
\code{version} (relevant when extracted from a DataSHIELD server-side package), \code{type} ("aggregate"),
\code{class} ("function" for package functions or "script" for custom scripts).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The aggregate methods when no parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-aggregateMethod"></a>}}
\if{latex}{\out{\hypertarget{method-aggregateMethod}{}}}
\subsection{Method \code{aggregateMethod()}}{
Get or set an aggregate method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$aggregateMethod(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The client function call.}

\item{\code{value}}{The translated server call: either a package function reference or function expression. Remove the method when \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The aggregate method when no \code{value} parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assignMethods"></a>}}
\if{latex}{\out{\hypertarget{method-assignMethods}{}}}
\subsection{Method \code{assignMethods()}}{
Get or set the assign methods.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$assignMethods(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A \code{data.frame} with columns: \code{name} (the client function call), \code{value} (the translated server call),
\code{package} (relevant when extracted from a DataSHIELD server-side package), \code{version} (relevant when extracted from a DataSHIELD server-side package),
\code{type} ("assign"), \code{class} ("function" for package functions or "script" for custom scripts).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The assign methods when no parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assignMethod"></a>}}
\if{latex}{\out{\hypertarget{method-assignMethod}{}}}
\subsection{Method \code{assignMethod()}}{
Get or set an assign method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$assignMethod(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The client function call}

\item{\code{value}}{The translated server call: either a package function reference or function expression. Remove the method when \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The assign method when no \code{value} parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-options"></a>}}
\if{latex}{\out{\hypertarget{method-options}{}}}
\subsection{Method \code{options()}}{
Get or set the DataSHIELD R options that are applied when a new DataSHIELD session is started.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$options(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A named list of options.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The R options when no parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-option"></a>}}
\if{latex}{\out{\hypertarget{method-option}{}}}
\subsection{Method \code{option()}}{
Get or set a R option.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$option(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The R option's name.}

\item{\code{value}}{The R option's value. Remove the option when \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The R option's value when only \code{key} parameter is provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-newSession"></a>}}
\if{latex}{\out{\hypertarget{method-newSession}{}}}
\subsection{Method \code{newSession()}}{
Create a new DataSHIELD session (contained execution environment), apply options that are defined
in the DataSHIELD configuration and restore workspace image if \code{restore} workspace name argument is provided.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$newSession(restore = NULL, profile = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{restore}}{The workspace image to be restored (optional).}

\item{\code{profile}}{The requested profile name (optional). If provided, new session creation will fail in case it does not match the server's profile name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hasSession"></a>}}
\if{latex}{\out{\hypertarget{method-hasSession}{}}}
\subsection{Method \code{hasSession()}}{
Check a DataSHIELD session is alive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$hasSession(sid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSession"></a>}}
\if{latex}{\out{\hypertarget{method-getSession}{}}}
\subsection{Method \code{getSession()}}{
Get the DataSHIELD session's environment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$getSession(sid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSessionIds"></a>}}
\if{latex}{\out{\hypertarget{method-getSessionIds}{}}}
\subsection{Method \code{getSessionIds()}}{
Get the DataSHIELD session IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$getSessionIds()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSessionData"></a>}}
\if{latex}{\out{\hypertarget{method-getSessionData}{}}}
\subsection{Method \code{getSessionData()}}{
Get the symbol value from the DataSHIELD session's environment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$getSessionData(sid, symbol)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}

\item{\code{symbol}}{The symbol name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-closeSession"></a>}}
\if{latex}{\out{\hypertarget{method-closeSession}{}}}
\subsection{Method \code{closeSession()}}{
Destroy DataSHIELD session and save workspace image if \code{save} workspace name argument is provided.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$closeSession(sid, save = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}

\item{\code{save}}{The name of the workspace image to be saved (optional).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tableNames"></a>}}
\if{latex}{\out{\hypertarget{method-tableNames}{}}}
\subsection{Method \code{tableNames()}}{
List the names of the tables that can be assigned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$tableNames()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hasTable"></a>}}
\if{latex}{\out{\hypertarget{method-hasTable}{}}}
\subsection{Method \code{hasTable()}}{
Check a table exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$hasTable(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The table name to be looked for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resourceNames"></a>}}
\if{latex}{\out{\hypertarget{method-resourceNames}{}}}
\subsection{Method \code{resourceNames()}}{
List the names of the resources (\code{resourcer::Resource} objects) that can be assigned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$resourceNames()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hasResource"></a>}}
\if{latex}{\out{\hypertarget{method-hasResource}{}}}
\subsection{Method \code{hasResource()}}{
Check a resource (\code{resourcer::Resource} object) exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$hasResource(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The resource name to be looked for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-symbols"></a>}}
\if{latex}{\out{\hypertarget{method-symbols}{}}}
\subsection{Method \code{symbols()}}{
List the symbols living in a DataSHIELD session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$symbols(sid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-symbol_rm"></a>}}
\if{latex}{\out{\hypertarget{method-symbol_rm}{}}}
\subsection{Method \code{symbol_rm()}}{
Remove a symbol from a DataSHIELD session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$symbol_rm(sid, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}

\item{\code{name}}{The symbol name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assignTable"></a>}}
\if{latex}{\out{\hypertarget{method-assignTable}{}}}
\subsection{Method \code{assignTable()}}{
Assign a table to a symbol in a DataSHIELD session. Filter
table columns with the variables names provided.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$assignTable(sid, symbol, name, variables = NULL, id.name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}

\item{\code{symbol}}{The symbol to be assigned.}

\item{\code{name}}{The table's name.}

\item{\code{variables}}{The variable names to be filtered in (optional).}

\item{\code{id.name}}{The column name to be used for the entity's identifier (optional).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assignResource"></a>}}
\if{latex}{\out{\hypertarget{method-assignResource}{}}}
\subsection{Method \code{assignResource()}}{
Assign a resource as a \code{resourcer::ResourceClient} object to a symbol in a DataSHIELD session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$assignResource(sid, symbol, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}

\item{\code{symbol}}{The symbol name.}

\item{\code{name}}{The name of the resource.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assignExpr"></a>}}
\if{latex}{\out{\hypertarget{method-assignExpr}{}}}
\subsection{Method \code{assignExpr()}}{
Evaluate an assignment expression in a DataSHIELD session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$assignExpr(sid, symbol, expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}

\item{\code{symbol}}{The symbol name.}

\item{\code{expr}}{The R expression to evaluate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-aggregate"></a>}}
\if{latex}{\out{\hypertarget{method-aggregate}{}}}
\subsection{Method \code{aggregate()}}{
Evaluate an aggregate expression in a DataSHIELD session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$aggregate(sid, expr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{The session ID.}

\item{\code{expr}}{The R expression to evaluate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSLiteServer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
