% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_Characteristics_of_ID_ode.R
\name{simulate_Characteristics_of_ID_ode}
\alias{simulate_Characteristics_of_ID_ode}
\title{Characteristics of ID}
\usage{
simulate_Characteristics_of_ID_ode(
  S = 1000,
  P = 1,
  A = 0,
  I = 0,
  R = 0,
  D = 0,
  bP = 0,
  bA = 0,
  bI = 0.001,
  gP = 0.1,
  gA = 0.1,
  gI = 0.1,
  f = 0,
  d = 0,
  tstart = 0,
  tfinal = 200,
  dt = 0.1
)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{P}{: starting value for Presymptomatic : numeric}

\item{A}{: starting value for Asymptomatic : numeric}

\item{I}{: starting value for Symptomatic : numeric}

\item{R}{: starting value for Recovered : numeric}

\item{D}{: starting value for Dead : numeric}

\item{bP}{: rate of transmission from P to S : numeric}

\item{bA}{: rate of transmission from A to S : numeric}

\item{bI}{: rate of transmission from I to S : numeric}

\item{gP}{: rate at which a person leaves the P compartment : numeric}

\item{gA}{: rate at which a person leaves the A compartment : numeric}

\item{gI}{: rate at which a person leaves the I compartment : numeric}

\item{f}{: fraction of asymptomatic infections : numeric}

\item{d}{: fraction of symptomatic hosts that die : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A compartmental model with several different compartments: Susceptibles (S), Infected and Pre-symptomatic (P), Infected and Asymptomatic (A), Infected and Symptomatic (I), Recovered and Immune (R) and Dead (D)
}
\details{
The model tracks the dynamics of susceptible, presymptomatic, asymptomatic, symptomatic, recovered, and dead individuals. Susceptible (S) individuals can become infected by presymptomatic (P), asymptomatic (A), or infected (I) hosts. All infected individuals enter the presymptomatic stage first, from which they can become symptomatic or asymptomatic. Asymptomatic hosts recover within some specified duration of time, while infected hosts either recover or die, thus entering either R or D. Recovered individuals are immune to reinfection. This model is part of the DSAIDE R package, more information can be found there.

This code was generated by the modelbuilder R package.  
The model is implemented as a set of ordinary differential equations using the deSolve package. 
The following R packages need to be loaded for the function to work: deSolve.
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel, Alexis Vittengl
}

\section{Model creation date}{
 2020-09-29
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2021-07-19
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_Characteristics_of_ID_ode() 
# To choose values other than the standard one, specify them like this:  
result <- simulate_Characteristics_of_ID_ode(S = 2000,P = 2,A = 0,I = 0,R = 0,D = 0) 
# You can display or further process the result, like this:  
plot(result$ts[,'time'],result$ts[,'S'],xlab='Time',ylab='Numbers',type='l') 
print(paste('Max number of S: ',max(result$ts[,'S']))) 
}
