% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataAccess.R
\name{quantileDataAccess}
\alias{quantileDataAccess}
\title{Differentially Private Quantile Data Access Function}
\usage{
quantileDataAccess(x, quant, lower.bound, upper.bound)
}
\arguments{
\item{x}{Numeric vector.}

\item{quant}{Real number between 0 and 1 indicating which quantile to return.}

\item{lower.bound}{Real number giving the lower bound of the input data.}

\item{upper.bound}{Real number giving the upper bound of the input data.}
}
\value{
List of a vector corresponding to the utility function, the sorted
and clipped vector of inputs and the sensitivity calculated based on
theoretical values.
}
\description{
This function performs the data access step in the computation of a
differentially private quantile. The utility vector is computed as in
\insertCite{Smith2011a;textual}{DPpack}, while the sensitivities are
calculated based on bounded and unbounded differential privacy
\insertCite{Kifer2011}{DPpack} according to the theoretical values
\insertCite{Gillenwater2021}{DPpack}.
}
\examples{
quantileDataAccess(c(1,1,-2,8,-6),.25,-10,10)

}
\references{
\insertRef{Kifer2011}{DPpack}

\insertRef{Smith2011a}{DPpack}

\insertRef{Gillenwater2021}{DPpack}
}
\keyword{internal}
