% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmScaleTest.R
\name{harmScaleTest}
\alias{harmScaleTest}
\title{Test for difference in scales upon harmonic regressions}
\usage{
harmScaleTest(val1, val2, times1, times2, period, norm = TRUE)
}
\arguments{
\item{val1}{matrix: data for values in first set. One column per
sample, one row per time point}

\item{val2}{matrix: data for values in second set. One column per
sample, one row per time point}

\item{times1}{vector: times of first set.}

\item{times2}{vector: times of second set.}

\item{period}{numeric: period of the oscillations. Same unit as the
time points in times1 and times2}

\item{norm}{boolean: whether to normalize the time series (division by mean),
prior to the analysis.}
}
\value{
dataframe with following columns:
\itemize{
\item{p.value: }{P-value for difference between the two time series}
\item{score: }{score from the underlying F test}
}
}
\description{
The Test uses the F-Test for variances to decide wether the two given
time series have a comparable noise scale or on of the series has a higher
noise level.
}

