% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NMFpval.R
\name{NMFpval}
\alias{NMFpval}
\title{P value for discriminant Non-Negative Matrix Factorization}
\usage{
NMFpval(nmf_res, np = 100, ncores = parallel::detectCores(), fdr = FALSE,
  top = 1000, verbose = FALSE)
}
\arguments{
\item{nmf_res}{result from DNMF or dNMF}

\item{np}{number of permutations}

\item{ncores}{cores used. Default is all the availiable cores}

\item{fdr}{false discovery rate. Default is FALSE}

\item{top}{only include top ranked genes. Default is 1000}

\item{verbose}{verbose}
}
\value{
a matrix with columns rnk, p (and fdr)
}
\description{
Estimate the significance of differentially expressed genes in parallel.
}
\details{
P value is caculated based on aatricle, Wang, Hong-Qiang, Chun-Hou Zheng, and Xing-Ming Zhao.
"jNMFMA: a joint non-negative matrix factorization meta-analysis of
 transcriptomics data." Bioinformatics (2014): btu679.
}
\examples{
dat <- rbind(matrix(c(rep(3, 16), rep(8, 24)), ncol=5),
matrix(c(rep(5, 16), rep(5, 24)), ncol=5),
matrix(c(rep(18, 16), rep(7, 24)), ncol=5)) +
matrix(runif(120,-1,1), ncol=5)
trainlabel <- c(1,1,2,2,2)

nmf_res <- ndNMF(dat, trainlabel, r=2, lambada = 0.1)
pMat <- NMFpval(nmf_res, np=10, ncores=2, top=4)
}
\author{
Zhilong Jia
}

