% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cv.DMR.R
\name{predict.cv.DMR}
\alias{predict.cv.DMR}
\title{predict.cv.DMR}
\usage{
\method{predict}{cv.DMR}(
  object,
  newx,
  type = "link",
  md = "df.min",
  unknown.factor.levels = "error",
  ...
)
}
\arguments{
\item{object}{Fitted cv.DMR object.}

\item{newx}{Data frame of new values for \code{X} at which predictions are to be made.}

\item{type}{One of: \code{"link"}, \code{"response"}, \code{"class"}. For \code{family="gaussian"} for all values of \code{type} it gives the fitted values. For \code{family="binomial"} and \code{type="link"} it returns the linear predictors, for \code{type="response"} it returns the fitted probabilities and for \code{type="class"} it produces the class labels corresponding to the maximum probability.}

\item{md}{Value of the model dimension parameter at which predictions are required. The default is \code{md="df.min"} value indicating the model minimizing the cross validation error. Alternatively, \code{md="df.1se"} can be used, indicating the smallest model falling under the upper curve of a prediction error plus one standard deviation.}

\item{unknown.factor.levels}{The way of handling factor levels in test data not seen while training a model. One of \code{"error"} (the default - throwing an error) or \code{"NA"} (returning \code{NA} in place of legitimate value for problematic rows).}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector of predictions.
}
\description{
Make predictions from a cv.DMR object (for the model with minimal cross-validated error /the default/ or the smallest model falling under the upper curve of a prediction error plus one standard deviation).
}
\details{
Similar to other \code{predict} methods, this function predicts fitted values from a fitted \code{cv.DMR} object.
}
\examples{
## cv.DMR for linear regression
set.seed(13)
data(miete)
ytr <- miete$rent[1:1500]
Xtr <- miete$area[1:1500]
Xte <- miete$area[1501:2053]
cv <- cv.DMR(Xtr, ytr)
print(cv)
plot(cv)
coef(cv)
ypr <- predict(cv, newx = Xte)

}
