% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cv.DMR.R
\name{predict.cv.DMR}
\alias{predict.cv.DMR}
\title{predict.cv.DMR}
\usage{
\method{predict}{cv.DMR}(object, newx, type = "link", ...)
}
\arguments{
\item{object}{Fitted cv.DMR object.}

\item{newx}{Data frame of new values for X at which predictions are to be made.}

\item{type}{One of: link, response, class. For "gaussian" for all values of type it gives the fitted values. For "binomial" type "link" gives the linear predictors, for type "response" it gives the fitted probabilities and for type "class" it produces  the  class  label  corresponding  to  the  maximum  probability.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector of predictions.
}
\description{
Make predictions from a cv.DMR object (for the model with minimal cross-validated error).
}
\details{
Similar to other predict methods, this function predicts fitted values from a fitted cv.DMR object for the model with minimal cross-validated error.
}
\examples{
## cv.DMR for linear regression
set.seed(13)
data(miete)
ytr <- miete$rent[1:1500]
Xtr <- miete$area[1:1500]
Xte <- miete$area[1501:2053]
cv <- cv.DMR(Xtr, ytr)
print(cv)
plot(cv)
coef(cv)
ypr <- predict(cv, newx = Xte)

}

