\name{relabel}
\alias{relabel}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
A Relabel Algorithm 
}
\description{
Function \code{relabel} implements Algorithm 2 in Matthew Stephens (2000) JRSSB for the posterior allocation probability matrix, minimizing the Kullback-Leibler distance.  Step 2 in this algorithm is solved using the Hungarian (Munkres) algorithm to the assignment problem.
}
\usage{
relabel(probs.mcmc, nIter, nItem, nClust, 
    RELABEL.THRESHOLD, PRINT = 0, PACKAGE="DIRECT")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{probs.mcmc}{
A \code{nItem}*\code{nIter}-by-\code{nClust} matrix of samples of the posterior allocation probability matrix stored in file *_mcmc_probs.out generated by \code{\link{resampleClusterProb}}.
}
  \item{nIter}{
Number of stored MCMC samples.
}
  \item{nItem}{
Number of items.
}
  \item{nClust}{
Number of inferred clusters.
}
  \item{RELABEL.THRESHOLD}{
A positive scalar.  Used to determine whether the optimization in the relabeling algorithm has converged.  
}
  \item{PRINT}{
If TRUE, print intermediate values onto the screen.  Used for debugging with small data sets.  
}
  \item{PACKAGE}{
Not for use.
}
}
\value{
Permuted labels for each store MCMC sample are written to file *_mcmc_perms.out, in which each row contains an inferred permutation (relabel) of labels of mixture components.
}
\references{
Fu, A. Q., Russell, S., Bray, S. J. and Tavare, S. Bayesian clustering with the Dirichlet-process prior.  

Stephens, M. (2000) Dealing with label switching in mixture models. Journal of the Royal Statistical Society, Series B, 62: 795-809.
}
\author{
Audrey Q. Fu
}
\note{
This function calls a routine written in C, where implementation of Munkres algorithm is adapted from the C code by Dariush Lotfi (June 2008; web download).
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{DIRECT}} for the complete method.

\code{\link{DPMCMC}} for the MCMC sampler under the Dirichlet-process prior.

\code{\link{resampleClusterProb}} for resampling of posterior allocation probability matrix in posterior inference.
}
\examples{
## See example for DIRECT.
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
