% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsParametric.R
\name{testOverdispersionParametric}
\alias{testOverdispersionParametric}
\title{Parametric overdispersion test}
\usage{
testOverdispersionParametric(model)
}
\arguments{
\item{model}{a fitted model object. See details for possible models}
}
\description{
This function implements a parametric dispersion test based on comparing the residual deviance to the residual degrees of freedom that is commonly used, with the purpose of benchmarking against the nonparametric tests of DHARMA
}
\details{
The general idea of such as test is to copy GLM wisdom that we can define a dispersion parameter as residual deviance / residual degrees of freedom. For a model with correct dispersion, this parameter

1. Should be on average 1
2. Be chi2 distributed with df = rdf

For GL(M)Ms, we have to answer three questions

1. What is the residual deviance
2. What are the rdf
3. Is the distribution still chisq

There are quite a few implementations of this idea, e.g. https://stat.ethz.ch/pipermail/r-sig-mixed-models/2011q1/015392.html (implemented in blmeco::dispersion_glmer), http://glmm.wikidot.com/faq, and the code from Harrison, X. A. Using observation-level random effects to model overdispersion in count data in ecology and evolution PeerJ, 2014, 2, e616 
 
The implementation here follows the suggestion in http://glmm.wikidot.com/faq, which is based on dividing the pearson residuals by the (probably not completely accurate) rdf, and testing this against a chi2 distribution with df = rdf.
}
\seealso{
\code{\link{testSimulatedResiduals}}, \code{\link{testSimulatedResiduals}}, \code{\link{testZeroInflation}}, \code{\link{testTemporalAutocorrelation}}, \code{\link{testSpatialAutocorrelation}}
}
