% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResiduals.R
\name{if predictor is a factor, a boxplot will be plotted instead of a scatter plot.}
\alias{if predictor is a factor, a boxplot will be plotted instead of a scatter plot.}
\alias{plotResiduals}
\title{Generic residual plot with either spline or quantile regression}
\usage{
plotResiduals(pred, residual, quantreg = T, ...)
}
\arguments{
\item{pred}{predictor variable}

\item{residual}{residual variable}

\item{quantreg}{should a quantile regression be performed. If F, a smooth spline will be plotted}

\item{...}{additional arguments to plot}
}
\description{
The function creates a generic residual plot with either spline or quantile regression
}
\details{
For a correctly specified model, we would expect uniformity in y direction when plotting against any predictor.

To provide a visual aid in detecting deviations from uniformity in y-direction, the plot of the residuals against the predited values also performs an (optional) quantile regression, which provides 0.25, 0.5 and 0.75 quantile lines across the plots. These lines should be straight, horizontal, and at y-values of 0.25, 0.5 and 0.75. Note, however, that some deviations from this are to be expected by chance, even for a perfect model, especially if the sample size is small.

The quantile regression can take some time to calculate, especially for larger datasets. For that reason, quantreg = F can be set to produce a smooth spline instead. 

If the predictor is a factor (categorial), a boxplot will be created - with a uniform distrituion, the box should go from 0.25 to 0.75, with the median line at 0.5. Again, chance deviations from this will increases when the sample size is smaller
}
\seealso{
\code{\link{plotSimulatedResiduals}}
}

