% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGOOnegroup.R
\name{plotGOOneGroup}
\alias{plotGOOneGroup}
\title{Plot results from a hypergeometric enrichment test for one condition.}
\usage{
plotGOOneGroup(dfList, nTerms = 5, minSize = 50, maxSize = 500,
  dataCol = "Pvalue", namesCol = "Term", labelsCol = "Ontology",
  legendTitle = "GO Type", adjustPVals = FALSE)
}
\arguments{
\item{dfList}{A named list of data frames corresponding to different GO term enrichments.}

\item{nTerms}{The number of most-enriched terms to plot from each GO term type.}

\item{minSize}{The number of genes above which a gene set should be removed from analysis (e.g., because it is so small as to be overly specific and untrustworthy).}

\item{maxSize}{The number of genes above which a gene set should be removed from analysis (e.g., because it is so big as to be overly generic and relatively uninteresting).}

\item{dataCol}{Column of the input matrix to be plotted in the bar plot. If "Pvalue", it will be -log10 transformed prior to plotting. If not "Pvalue", the x-axis label should be changed manually following the function call.}

\item{namesCol}{The column specifying the name of the GO terms to be plotted.}

\item{labelsCol}{The column specifying the fill labels of the GO terms to be plotted.}

\item{legendTitle}{The title for the legend in the resulting plot.}

\item{adjustPVals}{Logical, indicating whether or not p-values should be adjusted by the Benjamini-Hochberg method.}
}
\value{
An ggplot2 object that can be called in order to plot it, saved, or modified.
}
\description{
Uses ggplot2 to create a horizontal bar plot of the p-values (or odds-ratios) from enrichment tests of GO terms derived from differentially correlated gene sets (or any gene sets inputted into upstream functions). Note that the first column of each data frame is removed to allow for row binding, and otherwise the column names should match.
}

