% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{plotProportions}
\alias{plotProportions}
\title{Plot proportions}
\usage{
plotProportions(
  proportions,
  title = "Components",
  cex.lab = 1,
  cex.main = 1,
  cex.axis = 1
)
}
\arguments{
\item{proportions}{Matrix of the MCMC proportion samples. The matrix size is
number of the MCMC samples by the number of strains.}

\item{title}{Figure title.}

\item{cex.lab}{Label size.}

\item{cex.main}{Title size.}

\item{cex.axis}{Axis text size.}
}
\description{
Plot the MCMC samples of the proportion, indexed by the MCMC
 chain.
}
\examples{
\dontrun{
plafFile = system.file("extdata", "labStrains.test.PLAF.txt",
    package = "DEploid")
panelFile = system.file("extdata", "labStrains.test.panel.txt",
    package = "DEploid")
refFile = system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile = system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageT = extractCoverageFromTxt(refFile, altFile)
PG0390Coverage.deconv = dEploid(paste("-ref", refFile, "-alt", altFile,
    "-plaf", plafFile, "-noPanel"))
plotProportions(PG0390Coverage.deconv$Proportions, "PG0390-C proportions")
}

}
