% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{plotProportions}
\alias{plotProportions}
\title{Plot proportions}
\usage{
plotProportions(proportions, title = "Components")
}
\arguments{
\item{proportions}{Matrix of the MCMC proportion samples. The matrix size is number of the MCMC samples by the number of strains.}

\item{title}{Figure title.}
}
\description{
Plot the MCMC samples of the proportion, indexed by the MCMC chain.
}
\examples{
plafFile = system.file("extdata", "labStrains.test.PLAF.txt", package = "DEploid")
panelFile = system.file("extdata", "labStrains.test.panel.txt", package = "DEploid")
refFile = system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile = system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageTxt = extractCoverageFromTxt(refFile, altFile)
PG0390CoverageTxt.deconv = dEploid(paste("-ref", refFile, "-alt", altFile,
    "-plaf", plafFile, "-noPanel"))
plotProportions( PG0390CoverageTxt.deconv$Proportions, "PG0390-C proportions" )

}

