% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano.R
\name{de_volcano}
\alias{de_volcano}
\title{Visualize the expression & significance of differentially expressed genes.}
\usage{
de_volcano(res_list, filename = "volcano_plot.pdf", lfc_thresh = -1,
  strict_scale = TRUE, num_columns = 3, theme = 1,
  returnData = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets. Results can be calculated individually using DESeq's results() function.
Lists of results can be created by creating a list(result1, result2 ... result_N).}

\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation can be turned off using set_output_mode("screen"). Output will be written to the /DE/volcano/ directory.}

\item{lfc_thresh}{Log2 fold change threshold for highlighting genes on the volcano plot.}

\item{strict_scale}{Boolean. If this is true scales for all samples will be forced to be identical, otherwise scales will
vary depending on the dispersion of the volcano plot for each individual sample.}

\item{num_columns}{Number of columns to use in the grid layout. Default=3.}

\item{theme}{Theme for the layout and color scheme for the plot.  Valid selections are integers between 1-6.}

\item{returnData}{Boolean. Determines if this visualization should return data used to generate the visualization. Default=FALSE.}
}
\value{
If returnData is true, this function will return the long-form table of expression containing sample names,
categorical grouping, and sample IDs.
}
\description{
This function generates a volcano plot that displays the relation between expression and p-value for all DE
genes in a result set.
}
\examples{
\dontrun{

#Make a volcano plot highlighting DE genes above 1.5 LFC threshold.
de_volcano(result_list, filename="volcano.pdf", lfc_thresh=1.5, 
           strict_scale=TRUE, theme=1, returnData=FALSE)

}
}
\keyword{DE}
\keyword{expression}
\keyword{p-value}
\keyword{significance}
\keyword{visualization}
\keyword{volcano}
