% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{keep_data_subset}
\alias{keep_data_subset}
\title{Select a subset of count and target data based on metadata annotation.}
\usage{
keep_data_subset(counts, targets, target_count_id_map, target_keep_col,
  target_keep_val)
}
\arguments{
\item{counts}{Count data as prepared with prep_counts().}

\item{targets}{Target data as prepared with prep_targets().}

\item{target_count_id_map}{Column in targets file whose values corresponds with count data column ids.}

\item{target_keep_col}{Column in target data to select values by.  For instance, to select "day1" data
from the "timepoint" column, this argument should be "timepoint".}

\item{target_keep_val}{Value from target_keep_col to keep in the subset data. For instance, to select "day1" data
from the "timepoint" column, this argument should be "day1". Multiple values can be selected by providing a concatenated
set of values.  I.E. To keep day1 and day2 data, this argument should be, c("day1","day2").}
}
\value{
This function returns count and target data based on the target_keep_col and target_keep_val parameters.
Counts will be returned as the [[1]] index and target data will be returned as the [[2]] index.
}
\description{
This function, given count data and target metadata, will return a subset of both count and target data including
only data with values corresponding to selection parameters. For example, you can select count and target data for
only timepoint "day1".  Multiple valid keep selections can also be used.
}
\examples{
\dontrun{

myCounts <- prep_counts(count_input="master_count_data.txt", delim="t")
myTargets <- prep_targets(target_input="master_count_data.txt", delim="t")

#Get data for only "timepoint" at "day1".
data_subset <- keep_data_subset(counts=myCounts, targets=myTargets,
                                  target_count_id_map="sample_id",
                                  target_keep_col="timepoint",
                                  target_keep_val="day1")

#Count data is stored in the first index returned by the function.
subset_counts <- data_subset[[1]]

#Target data is stored in the second index returned by the function.
subset_targets <- data_subset[[2]]


#Get data for only "timepoint" at "day1" and "day2".
data_subset <- keep_data_subset(counts=myCounts, targets=myTargets,
                                  target_count_id_map="sample_id",
                                  target_keep_col="timepoint",
                                  target_keep_val=c("day1","day2"))

#Count data is stored in the first index returned by the function.
subset_counts <- data_subset[[1]]

#Target data is stored in the second index returned by the function.
subset_targets <- data_subset[[2]]

}
}
\seealso{
\code{\link{prep_counts}}, \code{\link{prep_targets}}, \code{\link{exclude_data_subset}}
}
\keyword{filter}
\keyword{subset}
