% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.R
\name{de_boxplot}
\alias{de_boxplot}
\title{Visualize differentially expressed genes as a function of experimental design.}
\usage{
de_boxplot(res_list, filename = "de_boxplot.pdf", theme = 1,
  returnData = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets. Results can be calculated individually using DESeq's results() function.
Lists of results can be created by creating a list(result1, result2 ... result_N).}

\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation can be turned off using set_output_mode("screen"). Output will be written to the /DE/boxplot/ directory.}

\item{theme}{Theme for the layout and color scheme for the plot.  Valid selections are integers between 1-6.}

\item{returnData}{Boolean. Determines if this visualization should return data used to generate the visualization. Default=FALSE.}
}
\value{
If returnData is true, this function will return the long-form table of expression containing
categorical grouping, and sample IDs, and log2 fold-change.
}
\description{
This function plots groupwise expression for all differentially expressed genes
with regard to the experimental design.  For example, for a differential expression design of
~Condition_Time, boxplots for differentially expressed genes for each condition_time case in
the targets metadata will be produced.
}
\examples{
\dontrun{

#Prepare a result list for aggregation.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)

#Plot differentially expressed genes for the aggregate result sets.
de_boxplot(res_list=myResList, filename="DE_condition_time_boxplot.pdf",
            theme=2, returnData=FALSE)

}
}
\keyword{DE}
\keyword{boxplot}
\keyword{distribution}
\keyword{expression}
\keyword{visualization}
