% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ships.methods.R
\docType{class}
\name{DeponsShips-class}
\alias{DeponsShips-class}
\title{DeponsShips-class}
\description{
Objects containing ship routes and ships

Methods for manipulating, plotting and analyzing ship routes
and ship agents used in DEPONS simulations.
}
\section{Slots}{

\describe{
\item{\code{title}}{Name of the object (character)}

\item{\code{landscape}}{Name of the landscape that the ships occur in (character)}

\item{\code{crs}}{CRS object providing the coordinate reference system used; see
\code{\link[sp]{CRS}} for details}

\item{\code{routes}}{\code{data.frame} geographic positions of the 'virtual buoys'
that define one or more ship routes that ship agents can follow}

\item{\code{ships}}{\code{data.frame} defining each of the ships occurring in DEPONS
simulations, and the route they occur on}
}}

\examples{
data(shipdata)
ships(shipdata)[1:10,]
routes(shipdata)
plot(shipdata, col=c("red", "purple", "blue"))
}
\seealso{
\code{\link[DEPONS2R]{plot.DeponsShips}} and
\code{\link[DEPONS2R]{read.DeponsShips}}
}
