\name{DCsum}
\alias{DCsum}
\title{ Summarize DCGs and DCLs}
\description{
  A algorithm to select synthetical DCGs and DCLs from the results of DCp and DCe.
}
\usage{
DCsum(DCp.res, DCe.res, DCpcutoff = 0.25, DCecutoff = 0.25)
}
\arguments{
  \item{DCp.res}{ a data frame generated by DCp, with rows as genes and columns as 'dC' score, 'links', 'p.value' and 'q.value' value. }
  \item{DCe.res}{ a list generated by DCe, with two components which are DCGs and DCLs. }
  \item{DCpcutoff}{ the cutoff of 'q.vaule' in DCp results; must be within [0,1]; If there is no 'q.value' value (when N=0), 'dC' will be sorted in decreasing order and retained the highest by 'DCpcutoff' percent.}
  \item{DCecutoff}{ the cutoff of 'q' in DCGs components of DCe results; must be within [0,1]. }
}
\details{
  DCsum, short for Differentially Coexpression Summarization, summarizes 1) a set of DCGs, which is an intersection 
  of DCp and DCe results; and 2) a set of DCLs which by definition must be connected with the DCGs. As a result, DCsum combines results from different 
  coexpression analysis methods.
}
\value{
  A list with two components:
  \item{DCGs}{Differentially Coexpressed Genes, combined two differential coexpression analysis}
  \item{DCLs}{Differentially Coexpressed Links, combined two differential coexpression analysis}
}
\author{ Jing Yang, Hui Yu}
\examples{
data(exprs)
DCp.res<-DCp(exprs[1:100,1:16],exprs[1:100,17:63],
	link.method = 'qth',cutoff=0.25)
DCe.res<-DCe(exprs[1:100,1:16],exprs[1:100,17:63],
	link.method = 'qth',cutoff=0.25,nbins=20,p=0.1)
DCsum.res<-DCsum(DCp.res,DCe.res,DCpcutoff=0.25,DCecutoff=0.25)

## Differentially Coexpressed Genes after combination
DCsum.res$DCGs[1:3,]

## Differentially Coexpressed Links after combination
DCsum.res$DCLs[1:3,]
}
\keyword{ Summary of DCGs}
\keyword{ Summary of DCLs}
