% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbSendStatement}
\alias{dbSendStatement}
\title{Execute a data manipulation statement on a given database connection}
\usage{
dbSendStatement(conn, statement, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{statement}{a character vector of length 1 containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
An object that inherits from \code{\linkS4class{DBIResult}}.
  Once you have finished using a result, make sure to disconnect it
  with \code{\link{dbClearResult}}.
}
\description{
The function \code{dbSendStatement} only submits and synchronously executes the
SQL data manipulation statement (e.g., \code{UPDATE}, \code{DELETE},
\code{INSERT INTO}, \code{DROP TABLE}, ...) to the database engine.  To query
the number of affected rows, call \code{\link{dbGetRowsAffected}} on the
returned result object.  You must also call \code{\link{dbClearResult}} after
that. For interactive use, you should almost always prefer
\code{\link{dbExecute}}.
}
\details{
\code{\link{dbSendStatement}} comes with a default implementation that simply
forwards to \code{\link{dbSendQuery}}, to support backends that only
implement the latter.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "cars", head(cars, 3))
rs <- dbSendStatement(con,
  "INSERT INTO cars (speed, dist) VALUES (1, 1), (2, 2), (3, 3);")
dbHasCompleted(rs)
dbGetRowsAffected(rs)
dbClearResult(rs)
dbReadTable(con, "cars")   # there are now 6 rows

dbDisconnect(con)
}
\seealso{
For queries: \code{\link{dbSendQuery}} and \code{\link{dbGetQuery}}.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}}
}

