% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbRemoveTable}
\alias{dbRemoveTable}
\title{Remove a table from the database}
\usage{
dbRemoveTable(conn, name, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{...}{Other parameters passed on to methods.}
}
\value{
a logical vector of length 1 indicating success or failure.
}
\description{
Executes the sql \code{DROP TABLE name}.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbExistsTable(con, "iris")
dbWriteTable(con, "iris", iris)
dbExistsTable(con, "iris")
dbRemoveTable(con, "iris")
dbExistsTable(con, "iris")

dbDisconnect(con)
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}}
}

