% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_extract_island_species.R
\name{multi_extract_island_species}
\alias{multi_extract_island_species}
\title{Extracts the colonisation, diversification, and endemicty data from multiple
`phylod` (`phylo4d` class from `phylobase`) objects (composed of phylogenetic
and endemicity data) and stores each in an `Island_tbl` object which are
stored in a `Multi_island_tbl` object.}
\usage{
multi_extract_island_species(
  multi_phylod,
  extraction_method,
  island_tbl = NULL,
  include_not_present = FALSE,
  verbose = FALSE,
  unique_clade_name = TRUE
)
}
\arguments{
\item{multi_phylod}{A list of phylod objects.}

\item{extraction_method}{A character string specifying whether the
colonisation time extracted is the minimum time (`min`) (before the present),
or the most probable time under ancestral state reconstruction (`asr`).}

\item{island_tbl}{An instance of the `Island_tbl` class.}

\item{include_not_present}{A boolean determining whether species not present
on the island should be included in island colonist when embedded within an
island clade. Default is FALSE.}

\item{verbose}{Boolean. States if intermediate results should be printed to
console. Defaults to FALSE}

\item{unique_clade_name}{Boolean determining whether a unique species
identifier is used as the clade name in the Island_tbl object or a genus
name which may not be unique if that genus has several independent island
colonisations}
}
\value{
An object of `Multi_island_tbl` class
}
\description{
Extracts the colonisation, diversification, and endemicty data from multiple
`phylod` (`phylo4d` class from `phylobase`) objects (composed of phylogenetic
and endemicity data) and stores each in an `Island_tbl` object which are
stored in a `Multi_island_tbl` object.
}
\examples{
multi_phylod <- list()
multi_phylod[[1]] <- create_test_phylod(test_scenario = 1)
multi_phylod[[2]] <- create_test_phylod(test_scenario = 2)
multi_island_tbl <- multi_extract_island_species(
  multi_phylod = multi_phylod,
  extraction_method = "min",
  island_tbl = NULL,
  include_not_present = FALSE
)
}
