% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_loglik_integrate.R
\name{DAISIE_loglik_integrate}
\alias{DAISIE_loglik_integrate}
\title{Integrates the loglikelihood of a single clade across a parameter weighted
by a given distribution}
\usage{
DAISIE_loglik_integrate(
  pars1,
  pars2,
  brts,
  stac,
  missnumspec,
  CS_version,
  methode,
  abstolint,
  reltolint,
  verbose
)
}
\arguments{
\item{pars1}{Vector of model parameters: \cr \cr \code{pars1[1]} corresponds
to lambda^c (cladogenesis rate) \cr \code{pars1[2]} corresponds to mu
(extinction rate) \cr \code{pars1[3]} corresponds to K (clade-level
carrying capacity) \cr \code{pars1[4]} corresponds to gamma
(immigration rate) \cr \code{pars1[5]} corresponds to lambda^a
(anagenesis rate).}

\item{pars2}{Vector of settings: \cr \cr \code{pars2[1]} corresponds to res,
the maximum number of endemics or non-endemics for which the ODE system is
solved; this must be much larger than the actual number for which the
probability needs to be calculated.) \cr \code{pars2[2]} corresponds to M,
size of the mainland pool, i.e the number of species that can potentially
colonize the island.}

\item{brts}{Numeric vector of branching times}

\item{stac}{Numeric of Endemicity status}

\item{missnumspec}{Numeric of missing species}

\item{CS_version}{a numeric or list. Default is 1 for the standard DAISIE
model, for a relaxed-rate model a list with the following elements:
\itemize{
  \item{model: the CS model to run, options are \code{1} for single rate
  DAISIE model, \code{2} for multi-rate DAISIE, or \code{0} for IW test
  model.}
  \item{relaxed_par: the parameter to relax (integrate over). Options are
\code{"cladogenesis"}, \code{"extinction"}, \code{"carrying_capacity"},
\code{"immigration"}, or \code{"anagenesis"}.}
  }}

\item{methode}{Method of the ODE-solver. Supported Boost \code{ODEINT}
solvers (steppers) are:
\code{"odeint::runge_kutta_cash_karp54"}
\code{"odeint::runge_kutta_fehlberg78"}
\code{"odeint::runge_kutta_dopri5"}
\code{"odeint::bulirsch_stoer"}
without \code{odeint::}-prefix, \code{\link{deSolve}{ode}} method is
assumed. The default method overall is
\code{"lsodes"} for \code{\link{DAISIE_ML_CS}()}
and \code{"ode45"} from \code{\link[deSolve]{ode}()} for
\code{\link{DAISIE_ML_IW}()}.}

\item{abstolint}{Numeric absolute tolerance of the integration}

\item{reltolint}{Numeric relative tolerance of the integration}

\item{verbose}{In simulation and dataprep functions a logical,
\code{Default = TRUE} gives intermediate output should be printed.
For ML functions a numeric determining if intermediate output should be
printed, \code{Default = 0} does not print, \code{verbose = 1} prints
intermediate output of the parameters and loglikelihood, \code{verbose = 2}
means also intermediate progress during loglikelihood computation is shown.}
}
\value{
A loglikelihood value
}
\description{
Integrates the loglikelihood of a single clade across a parameter weighted
by a given distribution
}
\keyword{internal}
