/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.infinite;

import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.swingworker.SwingWorker;
import org.mutoss.gui.RControl;
import org.mutoss.gui.dialogs.TextFileViewer;
import org.mutoss.gui.infinite.InfiniteRunningDialog;
import org.mutoss.gui.infinite.SearchProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfiteSearchSwingWorker
extends SwingWorker<SearchProgress, SearchProgress> {
    InfiniteRunningDialog ird;
    int run = 0;
    String fullcommand;
    boolean canceled = false;

    public InfiteSearchSwingWorker(InfiniteRunningDialog ird) {
        this.ird = ird;
    }

    protected SearchProgress doInBackground() throws Exception {
        boolean first = true;
        while (!this.canceled) {
            this.publish(new SearchProgress[]{this.newSearchProgress(first)});
            first = false;
        }
        return null;
    }

    private SearchProgress newSearchProgress(boolean first) {
        ++this.run;
        this.fullcommand = "Crossover:::infiniteSearchStep(" + (first ? "oldResult=NULL, " : "oldResult=.COresult, ") + this.ird.getCommand() + (first ? this.ird.models : "") + ")";
        RControl.getR().eval(".COresult <- " + this.fullcommand);
        double[] maxEff = RControl.getR().eval("Crossover:::getMaxEffPerRun(.COresult)").asRNumeric().getData();
        return new SearchProgress(this.run, maxEff, null);
    }

    protected void process(List<SearchProgress> chunks) {
        for (SearchProgress s : chunks) {
            this.ird.append(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        try {
            SearchProgress sp = (SearchProgress)this.get();
            String table = RControl.getR().eval("Crossover:::getTable(getDesign(.COresult))").asRChar().getData()[0];
            this.ird.gui.algorithmPanel.searchResultReady(table);
        }
        catch (CancellationException e) {
        }
        catch (Throwable e) {
            String message = e.getMessage();
            if (message.equals("Error: \n")) {
                message = "Empty message (most likely an error in the C++ code - please look at the R console for further output)\n\n";
            }
            JOptionPane.showMessageDialog(this.ird.gui, "R call produced an error:\n\n" + message + "\nWe will open a window with R code to reproduce this error for investigation.", "Error in R Call", 0);
            new TextFileViewer((JFrame)this.ird.gui, "R Objects", "The following R code produced the following error:\n\n" + message + this.fullcommand, true);
            e.printStackTrace();
        }
        finally {
            this.ird.gui.glassPane.stop();
            this.ird.dispose();
        }
    }

    public void cancel() {
        this.canceled = true;
    }
}

