% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_common_functions.R
\name{predict.Coxmos}
\alias{predict.Coxmos}
\title{predict.Coxmos}
\usage{
\method{predict}{Coxmos}(object, ..., newdata = NULL)
}
\arguments{
\item{object}{Coxmos model}

\item{...}{additional arguments affecting the predictions produced.}

\item{newdata}{Numeric matrix or data.frame. New data for explanatory variables (raw data).
Qualitative variables must be transform into binary variables.}
}
\value{
Score values data.frame for new data using the Coxmos model selected.
}
\description{
Generates the prediction score matrix for Partial Least Squares (PLS) Survival models,
facilitating the transformation of high-dimensional data into a reduced space while preserving the
most relevant information for survival analysis.
}
\details{
The \code{predict.Coxmos} function is designed to compute the prediction scores for new data
based on a previously trained PLS Survival model. The function leverages the dimensional reduction
capabilities of PLS to project the new data into a lower-dimensional space, which is particularly
beneficial when dealing with high-dimensional datasets in survival analysis. The score matrix
obtained serves as a compact representation of the original data, capturing the most salient
features that influence survival outcomes.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:50]
Y_train <- Y_proteomic[index_train,]

X_test <- X_proteomic[-index_train,1:50]
Y_test <- Y_proteomic[-index_train,]
model <- splsicox(X_train, Y_train, n.comp = 2) #after CV
predict(object = model, newdata = X_test)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
