% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_coxSW.R
\name{coxSW}
\alias{coxSW}
\title{coxSW}
\usage{
coxSW(
  X,
  Y,
  max.variables = 20,
  BACKWARDS = TRUE,
  alpha_ENT = 0.1,
  alpha_OUT = 0.15,
  toKeep.sw = NULL,
  initialModel = NULL,
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = FALSE,
  toKeep.zv = NULL,
  remove_non_significant = FALSE,
  alpha = 0.05,
  MIN_EPV = 5,
  returnData = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{X}{Numeric matrix or data.frame. Explanatory variables. Qualitative variables must be
transform into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{max.variables}{Numeric. Maximum number of variables you want to keep in the cox model. If
MIN_EPV is not meet, the value will be change automatically (default: 20).}

\item{BACKWARDS}{Logical. If BACKWARDS = TRUE, backward strategy is performed (default: TRUE).}

\item{alpha_ENT}{Numeric. Maximum P-Value threshold for an ANOVA test when comparing a more complex model to a simpler model that includes a new variable. If the p-value is less than or equal to this threshold, the new variable is considered significantly important and will be added to the model (default: 0.10).}

\item{alpha_OUT}{Numeric. Minimum P-Value threshold for an ANOVA test when comparing a simpler model to a more complex model that excludes an existing variable. If the p-value is greater than or equal to this threshold, the existing variable is considered not significantly important and will be removed from the model (default: 0.15).}

\item{toKeep.sw}{Character vector. Name of variables in X to not be deleted by Step-wise
selection (default: NULL).}

\item{initialModel}{Character vector. Name of variables in X to include in the initial model
(default: NULL).}

\item{x.center}{Logical. If x.center = TRUE, X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If x.scale = TRUE, X matrix is scaled to unit variances (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If remove_near_zero_variance = TRUE, near zero variance
variables will be removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If remove_zero_variance = TRUE, zero variance variables will
be removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Name of variables in X to not be deleted by (near) zero variance
filtering (default: NULL).}

\item{remove_non_significant}{Logical. If remove_non_significant = TRUE, non-significant
variables/components in final cox model will be removed until all variables are significant by
forward selection (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the
threshold (default: 0.05).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) you want reach for the final
cox model. Used to restrict the number of variables/components can be computed in final cox models.
If the minimum is not meet, the model cannot be computed (default: 5).}

\item{returnData}{Logical. Return original and normalized X and Y matrices (default: TRUE).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
Instance of class "Coxmos" and model "coxSW". The class contains the following elements:

\code{X}: List of normalized X data information.
\itemize{
\item \code{(data)}: normalized X matrix
\item \code{(x.mean)}: mean values for X matrix
\item \code{(x.sd)}: standard deviation for X matrix
}
\code{Y}: List of normalized Y data information.
\itemize{
\item \code{(data)}: normalized Y matrix
\item \code{(y.mean)}: mean values for Y matrix
\item \code{(y.sd)}: standard deviation for Y matrix
}
\code{survival_model}: List of survival model information
\itemize{
\item \code{fit}: coxph object.
\item \code{AIC}: AIC of cox model.
\item \code{BIC}: BIC of cox model.
\item \code{lp}: linear predictors for train data.
\item \code{coef}: Coefficients for cox model.
\item \code{YChapeau}: Y Chapeau residuals.
\item \code{Yresidus}: Y residuals.
}
\code{call}: call function

\code{X_input}: X input matrix

\code{Y_input}: Y input matrix

\code{nsv}: Variables removed by remove_non_significant if any.

\code{nzv}: Variables removed by remove_near_zero_variance or remove_zero_variance.

\code{nz_coeffvar}: Variables removed by coefficient variation near zero.

\code{removed_variables_correlation}: Variables removed by being high correlated with other
variables.

\code{class}: Model class.

\code{time}: time consumed for running the cox analysis.
}
\description{
The \code{coxSW} function conducts a stepwise Cox regression analysis on survival data,
leveraging the capabilities of the \code{My.stepwise} R package. The primary objective of this function
is to identify the most significant predictors for survival data by iteratively adding or removing
predictors based on their statistical significance in the model. The resulting model is of class
"Coxmos" with an attribute model labeled as "coxSW".
}
\details{
The \code{coxSW} function employs a stepwise regression technique tailored for survival data. This
method is particularly beneficial when dealing with a plethora of predictors, and there's a
necessity to distill the model to its most impactful variables. The stepwise procedure can be
configured to operate in forward, backward, or a hybrid mode, contingent on the parameters
specified by the user.

During the iterative process, variables are evaluated for inclusion or exclusion based on
predefined significance levels (\code{alpha_ENT} for entry and \code{alpha_OUT} for removal). This ensures
that the model retains only those predictors that meet the significance criteria, thereby
enhancing the model's interpretability and predictive power.

Additionally, the function offers several preprocessing options, such as centering and scaling of
the predictor matrix, removal of variables with near-zero or zero variance, and the ability to
enforce the inclusion of specific variables in the model. These preprocessing steps are crucial
for ensuring the robustness and stability of the resulting Cox regression model.

It's worth noting that the function is equipped to handle both numeric and binary categorical
predictors. However, it's imperative that categorical variables are appropriately transformed
into binary format before analysis. The outcome or response variable should comprise two columns:
"time" representing the survival time and "event" indicating the occurrence of the event of interest.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:10]
Y <- Y_proteomic
coxSW(X, Y, x.center = TRUE, x.scale = TRUE)
}
\references{
\insertRef{Efroymson_SW}{Coxmos}
\insertRef{coxSW_CRAN}{Coxmos}
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
