% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovDist.R
\name{CovDist}
\alias{CovDist}
\title{Compute pairwise distance for symmetric positive definite matrices.}
\usage{
CovDist(A, method = c("AIRM", "Bhattacharyya", "Cholesky", "Euclidean",
  "Hellinger", "JBLD", "KLDM", "LERM", "Procrustes.SS", "Procrustes.Full",
  "PowerEuclidean", "RootEuclidean"), power = 1)
}
\arguments{
\item{A}{a \eqn{(p\times p\times N)} 3d array of \eqn{N} SPD matrices.}

\item{method}{the type of distance measures to be used; \code{"AIRM"} for Affine Invariant
Riemannian Metric, \code{"Bhattacharyya"} for Bhattacharyya distance based on normal model,
\code{"Cholesky"} for Cholesky difference in Frobenius norm,
\code{"Euclidean"} for naive Frobenius norm as distance,
\code{"Hellinger"} for Hellinger distance based on normal model,
\code{"JBLD"} for Jensen-Bregman Log Determinant Distance,
\code{"KLDM"} for symmetrized Kullback-Leibler Distance Measure,
\code{"LERM"} for Log Euclidean Riemannian Metric,
\code{"Procrustes.SS"} for Procrustes Size and Shape measure,
\code{"Procrustes.Full"} for Procrustes analysis with scale,
\code{"PowerEuclidean"} for weighted eigenvalues by some exponent, and
\code{"RootEuclidean"} for matrix square root.}

\item{power}{a non-zero number for PowerEuclidean distance.}
}
\value{
an \eqn{(N\times N)} symmetric matrix of pairwise distances.
}
\description{
For a given 3-dimensional array where symmetric positive definite (SPD) matrices are stacked slice
by slice, it computes pairwise distance using various popular measures. Some of measures
are \emph{metric} as they suffice 3 conditions in mathematical context; nonnegative definiteness,
symmetry, and triangle inequalities. Other non-metric measures represent \emph{dissimilarities} between
two SPD objects.
}
\examples{
## generate 100 SPD matrices of size (5-by-5)
samples = samplecovs(100,5)

## get pairwise distance for "AIRM"
distAIRM = CovDist(samples, method="AIRM")

## dimension reduction using MDS
ss = cmdscale(distAIRM)
plot(ss[,1],ss[,2],main="2d projection")

}
\references{
\insertRef{arsigny_log-euclidean_2006}{CovTools}

\insertRef{dryden_non-euclidean_2009}{CovTools}
}
