% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markrank.R
\name{markrank}
\alias{markrank}
\title{MarkRank}
\usage{
markrank(dataset, label, adj_matrix, alpha, lambda, eps = 1e-10,
  E_value = NULL, trace = TRUE, d = Inf)
}
\arguments{
\item{dataset}{The microarray expression matrix of related disease. Each row represents
a sample and each column represents a gene.}

\item{label}{The 0-1 binary phenotype vector of dataset samples. The size of label must
accord with the sample number in dataset.}

\item{adj_matrix}{The 0-1 binary adjacent matrix of a connected biological network. 
Here the node set should be the same order as the gene set in expression matrix.}

\item{alpha}{The convex combination coefficient of network effect and prior information vector E.}

\item{lambda}{The convex combination coefficient of two network effects.}

\item{eps}{The stop criteria for the iterative solution method.}

\item{E_value}{A vector containing the prior information about the importance of nodes. Default is 
absolute Pearson correlation coefficient (PCC).}

\item{trace}{Locaical variable indicated whether tracing information on the progress of the iterative
solution method is produced.}

\item{d}{Threshold for simplifying G_2 computation. Only the gene pairs whose shortest distances in PPI network are 
less than d participate in G_2 computation. Default is Inf.}
}
\value{
This function will return a list with components:
  \item{score}{The vector of final MarkRank scores for each gene.}
  \item{steps}{The final steps used by iterative method.}
  \item{NET2}{The weighted adjacent matrix of discriminative potential network.}
  \item{initial_pars}{The initial parameter values used in computation.}
  \item{dis}{The pairwise distance matrix of input network. Null if d=Inf}
}
\description{
Prioritization of network biomarkers for complex diseases
}
\details{
MarkRank is a network biomarker identification method to prioritize disease genes 
by integrating multi-source information including the biological network, eg. 
protein-protein interaction (PPI) network, the prior information about related diseases,
and the discriminative power of cooperative gene combinations.

The random-walk based iteration formula is:

R = alpha*[lambda*A1 + (1-lambda)*A2]*R + (1-alpha)*E_value.
}
\references{
Duanchen Sun, Xianwen Ren, Eszter Ari, Tamas Korcsmaros, Peter Csermely,
Ling-Yun Wu. Prioritization of network biomarkers for complex diseases via MarkRank.
Manuscript, 2016.
}

