% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_par_copula.R
\name{rc_par_copula}
\alias{rc_par_copula}
\title{Copula regression models with parametric margins for bivariate right-censored data}
\source{
Tao Sun, Yi Liu, Richard J. Cook, Wei Chen and Ying Ding (2018).
Copula-based Score Test for Bivariate Time-to-event Data,
with Application to a Genetic Study of AMD Progression.
\emph{Lifetime Data Analysis} doi:10.1007/s10985-018-09459-5. \cr
Tao Sun and Ying Ding (2019).
Copula-based Semiparametric Transformation Model for Bivariate Data
Under General Interval Censoring.
http://arxiv.org/abs/1901.01918.
}
\usage{
rc_par_copula(data, var_list, copula = "Clayton", m.dist = "Weibull",
  n.cons = 4, method = "BFGS", iter = 500, stepsize = 1e-06,
  control = list())
}
\arguments{
\item{data}{a data frame; must have \code{id} (subject id), \code{ind} (1,2 for two margins),
\code{obs_time}, \code{status} (0 for right-censoring, 1 for event).}

\item{var_list}{the list of covariates to be fitted into the model.}

\item{copula}{specify the copula family.}

\item{m.dist}{specify the marginal baseline distribution.}

\item{n.cons}{number of pieces, only for \code{m.dist = "Piecewise"}.
Default is 4.}

\item{method}{optimization method (see \code{?optim}); default is \code{"BFGS"};
also can be \code{"Newton"} (see \code{?nlm}).}

\item{iter}{number of iterations when \code{method = "Newton"};
default is 500.}

\item{stepsize}{size of optimization step when \code{method = "Newton"};
default is 1e-6.}

\item{control}{a list of control parameters for methods other than \code{"Newton"};
see \code{?optim}.}
}
\description{
Fits a copula model with parametric margins for bivariate right-censored data.
}
\details{
The input data must be a data frame with columns \code{id} (subject id),
\code{ind} (1,2 for two margins; each id must have both \code{ind = 1 and 2}),
\code{obs_time}, \code{status} (0 for right-censoring, 1 for event)
and \code{covariates}. \cr


The supported copula models are \code{"Clayton"}, \code{"Gumbel"}, \code{"Frank"},
\code{"AMH"}, \code{"Joe"} and \code{"Copula2"}.
The \code{"Copula2"} model is a two-parameter copula model that incorporates
\code{Clayton} and \code{Gumbel} as special cases.
The parametric generator functions of copula functions are list below:

The Clayton copula has a generator \deqn{\phi_{\eta}(t) = (1+t)^{-1/\eta},}
with \eqn{\eta > 0} and Kendall's \eqn{\tau = \eta/(2+\eta)}.

The Gumbel copula has a generator \deqn{\phi_{\eta}(t) = \exp(-t^{1/\eta}),}
with \eqn{\eta \geq 1} and Kendall's \eqn{\tau = 1 - 1/\eta}.

The Frank copula has a generator \deqn{\phi_{\eta}(t) = -\eta^{-1}\log \{1+e^{-t}(e^{-\eta}-1)\},}
with \eqn{\eta \geq 0} and Kendall's \eqn{\tau = 1+4\{D_1(\eta)-1\}/\eta},
in which \eqn{D_1(\eta) = \frac{1}{\eta} \int_{0}^{\eta} \frac{t}{e^t-1}dt}.

The AMH copula has a generator \deqn{\phi_{\eta}(t) = (1-\eta)/(e^{t}-\eta),}
with \eqn{\eta \in [0,1)} and Kendall's \eqn{\tau =  1-2\{(1-\eta)^2 \log (1-\eta) + \eta\}/(3\eta^2)}.

The Joe copula has a generator \deqn{\phi_{\eta}(t) = 1-(1-e^{-t})^{1/\eta},}
with \eqn{\eta \geq 1} and Kendall's \eqn{\tau = 1 - 4 \sum_{k=1}^{\infty} \frac{1}{k(\eta k+2)\{\eta(k-1)+2\}}}.

The Two-parameter copula (Copula2) has a generator \deqn{\phi_{\eta}(t) = \{1/(1+t^{\alpha})\}^{\kappa},}
with \eqn{\alpha \in (0,1], \kappa > 0} and Kendall's \eqn{\tau = 1-2\alpha\kappa/(2\kappa+1)}. \cr



The supported marginal distributions are \code{"Weibull"} (proportional hazards),
\code{"Gompertz"} (proportional hazards), \code{"Piecewise"} (proportional hazards)
and \code{"Loglogistic"} (proportional odds).
These marginal distributions follow the standard parameterization in Wikipedia.
We also assume the same baseline parameters between two margins. \cr

The Weibull (PH) survival distribution is \deqn{\exp \{-(t/\lambda)^k  e^{Z^{\top}\beta}\},}
with \eqn{\lambda > 0} as scale and \eqn{k > 0} as shape.

The Gompertz (PH) survival distribution is \deqn{\exp \{-\frac{b}{a}(e^{at}-1) e^{Z^{\top}\beta}\},}
with \eqn{a > 0} as shape and \eqn{b > 0} as rate.

The Piecewise constant (PH) survival distribution is \deqn{\exp \{-\int_{0}^{t} \lambda_{0}(s) ds \ e^{Z^{\top}\beta}\},}
with \eqn{ \lambda_{0}(s) = \rho_{k}} for \eqn{s \in (a_{k-1},a_k]}.

The Loglogistic (PO) survival distribution is \deqn{\{1+(t/\lambda)^{k} e^{Z^{\top}\beta} \}^{-1},}
with \eqn{\lambda > 0} as scale and \eqn{k > 0} as shape. \cr


Optimization methods can be all methods (except \code{"Brent"}) from \code{optim},
such as \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"}.
Users can also use \code{"Newton"} (from \code{nlm}).
}
\examples{
# fit a Clayton-Weibull model
data(DRS)
clayton_wb <- rc_par_copula(data = DRS, var_list = "treat",
                            copula = "Clayton",
                            m.dist = "Weibull")
summary(clayton_wb)
}
